/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SwiftDeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(SwiftDeleteFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSegmentService segmentService;
    private final SwiftRegionService regionService;

    public SwiftDeleteFeature(SwiftSession session) {
        this(session, new SwiftSegmentService(session), new SwiftRegionService(session));
    }

    public SwiftDeleteFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, new SwiftSegmentService(session, regionService), regionService);
    }

    public SwiftDeleteFeature(SwiftSession session, SwiftSegmentService segmentService, SwiftRegionService regionService) {
        this.segmentService = segmentService;
        this.regionService = regionService;
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            callback.delete(file);
            try {
                if (file.isFile()) {
                    List<Path> segments = this.segmentService.list(file);
                    ((Client)this.session.getClient()).deleteObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
                    for (Path segment : segments) {
                        ((Client)this.session.getClient()).deleteObject(this.regionService.lookup(segment), this.containerService.getContainer(segment).getName(), this.containerService.getKey(segment));
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (this.containerService.isContainer(file)) {
                    ((Client)this.session.getClient()).deleteContainer(this.regionService.lookup(file), this.containerService.getContainer(file).getName());
                    continue;
                }
                try {
                    ((Client)this.session.getClient()).deleteObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
                }
                catch (GenericException e) {
                    if (new SwiftExceptionMappingService().map(e) instanceof NotfoundException) {
                        log.warn((Object)String.format("Ignore missing placeholder object %s", file));
                        continue;
                    }
                    throw e;
                }
            }
            catch (GenericException e) {
                throw new SwiftExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

