/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.resources;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.resources.DirectoryObject;

public class GroupItem
extends DirectoryObject {
    public static final URLTemplate METADATA_URL_TEMPLATE = new URLTemplate("/groups/$1");

    public GroupItem(OneDriveAPI api, String id) {
        super(api, id);
    }

    public Metadata getMetadata(OneDriveExpand ... expands) throws IOException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = METADATA_URL_TEMPLATE.build(this.getApi().getBaseURL(), query, this.getId());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        JsonObject jsonObject = response.getContent();
        response.close();
        return new Metadata(jsonObject);
    }

    public class Metadata
    extends DirectoryObject.Metadata {
        private boolean allowExternalSenders;
        private boolean autoSubscribeNewMembers;
        private ZonedDateTime createdDateTime;
        private String description;
        private String displayName;
        private boolean isSubscribedByMail;
        private String mail;
        private boolean mailEnabled;
        private String mailNickname;
        private ZonedDateTime onPremisesLastSyncDateTime;
        private String onPremisesSecurityIdentifier;
        private Boolean onPremisesSyncEnabled;
        private ZonedDateTime renewedDateTime;
        private boolean securityEnabled;
        private int unseenCount;
        private String visibility;
        private OneDriveDrive drive;

        public Metadata() {
            super(GroupItem.this);
            this.allowExternalSenders = false;
            this.autoSubscribeNewMembers = false;
            this.isSubscribedByMail = true;
            this.onPremisesSyncEnabled = null;
        }

        public Metadata(JsonObject json) {
            super(GroupItem.this, json);
            this.allowExternalSenders = false;
            this.autoSubscribeNewMembers = false;
            this.isSubscribedByMail = true;
            this.onPremisesSyncEnabled = null;
        }

        @Override
        public GroupItem asDirectoryObject() {
            return GroupItem.this;
        }

        public boolean isAllowExternalSenders() {
            return this.allowExternalSenders;
        }

        public boolean isAutoSubscribeNewMembers() {
            return this.autoSubscribeNewMembers;
        }

        public ZonedDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isSubscribedByMail() {
            return this.isSubscribedByMail;
        }

        public String getMail() {
            return this.mail;
        }

        public boolean isMailEnabled() {
            return this.mailEnabled;
        }

        public String getMailNickname() {
            return this.mailNickname;
        }

        public ZonedDateTime getOnPremisesLastSyncDateTime() {
            return this.onPremisesLastSyncDateTime;
        }

        public String getOnPremisesSecurityIdentifier() {
            return this.onPremisesSecurityIdentifier;
        }

        public Boolean getOnPremisesSyncEnabled() {
            return this.onPremisesSyncEnabled;
        }

        public ZonedDateTime getRenewedDateTime() {
            return this.renewedDateTime;
        }

        public boolean isSecurityEnabled() {
            return this.securityEnabled;
        }

        public int getUnseenCount() {
            return this.unseenCount;
        }

        public String getVisibility() {
            return this.visibility;
        }

        public OneDriveDrive getDrive() {
            return this.drive;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            String name = member.getName();
            JsonValue value = member.getValue();
            try {
                switch (name) {
                    case "allowExternalSenders": {
                        this.allowExternalSenders = value.asBoolean();
                        break;
                    }
                    case "autoSubscribeNewMembers": {
                        this.autoSubscribeNewMembers = value.asBoolean();
                        break;
                    }
                    case "createdDateTime": {
                        this.createdDateTime = ZonedDateTime.parse(value.asString());
                        break;
                    }
                    case "description": {
                        this.description = value.asString();
                        break;
                    }
                    case "displayName": {
                        this.displayName = value.asString();
                        break;
                    }
                    case "isSubscribedByMail": {
                        this.isSubscribedByMail = value.asBoolean();
                        break;
                    }
                    case "mail": {
                        this.mail = value.asString();
                        break;
                    }
                    case "mailEnabled": {
                        this.mailEnabled = value.asBoolean();
                        break;
                    }
                    case "mailNickname": {
                        this.mailNickname = value.asString();
                        break;
                    }
                    case "onPremisesLastSyncDate": {
                        this.onPremisesLastSyncDateTime = ZonedDateTime.parse(value.asString());
                        break;
                    }
                    case "onPremisesSecurityIdentifier": {
                        this.onPremisesSecurityIdentifier = value.asString();
                        break;
                    }
                    case "onPremisesSyncEnabled": {
                        this.onPremisesSyncEnabled = value.isNull() ? null : Boolean.valueOf(value.asBoolean());
                        break;
                    }
                    case "renewedDateTime": {
                        this.renewedDateTime = ZonedDateTime.parse(value.asString());
                        break;
                    }
                    case "securityEnabled": {
                        this.securityEnabled = value.asBoolean();
                        break;
                    }
                    case "unseenCount": {
                        this.unseenCount = value.asInt();
                        break;
                    }
                    case "visibility": {
                        this.visibility = value.asString();
                        break;
                    }
                    case "drive": {
                        JsonObject driveObject = value.asObject();
                        JsonValue driveIdName = driveObject.get("string");
                        if (null != driveIdName) {
                            String driveId = driveIdName.asString();
                            this.drive = new OneDriveDrive(GroupItem.this.getApi(), driveId);
                        }
                        break;
                    }
                    case "groupTypes": 
                    case "proxyAddresses": 
                    case "acceptedSenders": 
                    case "calendar": 
                    case "calendarView": 
                    case "conversations": 
                    case "createdOnBehalfOf": 
                    case "extensions": 
                    case "memberOf": 
                    case "members": 
                    case "onenote": 
                    case "owners": 
                    case "photo": 
                    case "photos": 
                    case "planner": 
                    case "rejectedSenders": 
                    case "settings": 
                    case "sites": 
                    case "threads": {
                        break;
                    }
                    default: {
                        super.parseMember(member);
                        break;
                    }
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }
    }
}

