/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.CompleteMultiPartUploadResponse;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.models.CompleteMultipartUploadResult;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class CompleteMultiPartUploadResponseParser
extends AbstractResponseParser<CompleteMultiPartUploadResponse> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public CompleteMultiPartUploadResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        CompleteMultipartUploadResult result = XmlOutput.fromXml(inputStream, CompleteMultipartUploadResult.class);
                        CompleteMultiPartUploadResponse completeMultiPartUploadResponse = new CompleteMultiPartUploadResponse(result, this.getChecksum(), this.getChecksumType());
                        return completeMultiPartUploadResponse;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

