/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TransferItemFinder;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.transfer.TransferItem;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;

public class UploadTransferItemFinder
implements TransferItemFinder {
    @Override
    public Set<TransferItem> find(CommandLine input, TerminalAction action, Path remote) {
        Local local = LocalFactory.get(input.getOptionValues(action.name())[1]);
        HashSet<TransferItem> items = new HashSet<TransferItem>();
        items.add(this.resolve(remote, local));
        for (String arg : input.getArgs()) {
            items.add(this.resolve(remote, LocalFactory.get(arg)));
        }
        return items;
    }

    protected TransferItem resolve(Path remote, Local local) {
        if (local.isDirectory()) {
            if (remote.isDirectory()) {
                return new TransferItem(new Path(remote, local.getName(), EnumSet.of(AbstractPath.Type.directory)), local);
            }
            return new TransferItem(new Path(remote.getParent(), remote.getName(), EnumSet.of(AbstractPath.Type.directory)), local);
        }
        if (remote.isDirectory()) {
            return new TransferItem(new Path(remote, local.getName(), EnumSet.of(AbstractPath.Type.file)), local);
        }
        return new TransferItem(remote, local);
    }
}

