/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.i18n;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RegexLocale
implements Locale {
    private static final Logger log = Logger.getLogger(RegexLocale.class);
    private final Set<String> tables = new HashSet<String>();
    private final LRUCache<Key, String> cache = LRUCache.build(1000L);
    private final Local resources;
    private String locale = java.util.Locale.getDefault().getLanguage();
    private final Pattern pattern = Pattern.compile("\"(.*)\"\\s*=\\s*\"(.*)\";");

    public RegexLocale() {
        this(ApplicationResourcesFinderFactory.get().find());
    }

    public RegexLocale(Local resources) {
        this.resources = resources;
    }

    @Override
    public void setDefault(String language) {
        this.locale = language;
        this.cache.clear();
        this.tables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String localize(String key, String table) {
        Key lookup = new Key(table, key);
        if (!this.cache.contains(lookup) && !this.tables.contains(table)) {
            try {
                this.load(table);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure loading properties from %s.strings. %s", table, e.getMessage()));
            }
            finally {
                this.tables.add(table);
            }
        }
        if (this.cache.contains(lookup)) {
            return this.cache.get(lookup);
        }
        return key;
    }

    private void load(String table) throws IOException {
        File file = new File(String.format("%s/%s.lproj/%s.strings.1", this.resources.getAbsolute(), this.locale, table));
        if (file.exists()) {
            this.load(table, file);
        } else {
            this.load(table, new File(String.format("%s/%s.lproj/%s.strings", this.resources.getAbsolute(), this.locale, table)));
        }
    }

    private void load(String table, File file) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_16));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = this.pattern.matcher(line);
                if (!matcher.matches()) continue;
                this.cache.put(new Key(table, matcher.group(1)), matcher.group(2));
            }
        }
    }

    private final class Key {
        private final String table;
        private final String key;

        public Key(String table, String key) {
            this.table = table;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key1 = (Key)o;
            if (!Objects.equals(this.key, key1.key)) {
                return false;
            }
            return Objects.equals(this.table, key1.table);
        }

        public int hashCode() {
            int result = this.table != null ? this.table.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key{");
            sb.append("table='").append(this.table).append('\'');
            sb.append(", key='").append(this.key).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

