/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.FolderTransferCollection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.TransferReaderFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferProgress;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.log4j.Logger;

public class TransferCollection
extends Collection<Transfer> {
    private static final Logger log = Logger.getLogger(TransferCollection.class);
    private static final long serialVersionUID = -6879481152545265228L;
    private static final TransferCollection DEFAULT_COLLECTION = new TransferCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "Queue.plist"));
    private final Local file;
    private final Reader<Transfer> reader = TransferReaderFactory.get();

    public static TransferCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    protected TransferCollection(Local file) {
        this.file = file;
    }

    @Override
    public void trimToSize() {
        FolderTransferCollection.defaultCollection().trimToSize();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        FolderTransferCollection.defaultCollection().ensureCapacity(minCapacity);
    }

    @Override
    public Transfer set(int index, Transfer element) {
        return FolderTransferCollection.defaultCollection().set(index, element);
    }

    @Override
    public boolean retainAll(java.util.Collection<?> c) {
        return FolderTransferCollection.defaultCollection().retainAll(c);
    }

    @Override
    public void forEach(Consumer<? super Transfer> action) {
        FolderTransferCollection.defaultCollection().forEach(action);
    }

    @Override
    public Spliterator<Transfer> spliterator() {
        return FolderTransferCollection.defaultCollection().spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super Transfer> filter) {
        return FolderTransferCollection.defaultCollection().removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<Transfer> operator) {
        FolderTransferCollection.defaultCollection().replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super Transfer> c) {
        FolderTransferCollection.defaultCollection().sort(c);
    }

    @Override
    public int size() {
        return FolderTransferCollection.defaultCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return FolderTransferCollection.defaultCollection().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return FolderTransferCollection.defaultCollection().contains(o);
    }

    @Override
    public Transfer get(int row) {
        return (Transfer)FolderTransferCollection.defaultCollection().get(row);
    }

    @Override
    public boolean addAll(java.util.Collection<? extends Transfer> hosts) {
        return FolderTransferCollection.defaultCollection().addAll(hosts);
    }

    @Override
    public boolean add(Transfer host) {
        return FolderTransferCollection.defaultCollection().add(host);
    }

    @Override
    public void add(int row, Transfer host) {
        FolderTransferCollection.defaultCollection().add(row, host);
    }

    @Override
    public Transfer remove(int row) {
        return (Transfer)FolderTransferCollection.defaultCollection().remove(row);
    }

    @Override
    public boolean remove(Object host) {
        return FolderTransferCollection.defaultCollection().remove(host);
    }

    @Override
    public int indexOf(Object elem) {
        return FolderTransferCollection.defaultCollection().indexOf(elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        return FolderTransferCollection.defaultCollection().lastIndexOf(elem);
    }

    @Override
    public void addListener(CollectionListener<Transfer> l) {
        FolderTransferCollection.defaultCollection().addListener(l);
    }

    @Override
    public void removeListener(CollectionListener<Transfer> l) {
        FolderTransferCollection.defaultCollection().removeListener(l);
    }

    @Override
    public void clear() {
        FolderTransferCollection.defaultCollection().clear();
    }

    @Override
    public boolean removeAll(java.util.Collection<?> c) {
        return FolderTransferCollection.defaultCollection().removeAll(c);
    }

    @Override
    public void collectionItemChanged(Transfer item) {
        FolderTransferCollection.defaultCollection().collectionItemChanged(item);
    }

    @Override
    public boolean addAll(int index, java.util.Collection<? extends Transfer> c) {
        return FolderTransferCollection.defaultCollection().addAll(index, c);
    }

    @Override
    public Iterator<Transfer> iterator() {
        return FolderTransferCollection.defaultCollection().iterator();
    }

    @Override
    public ListIterator<Transfer> listIterator() {
        return FolderTransferCollection.defaultCollection().listIterator();
    }

    @Override
    public ListIterator<Transfer> listIterator(int index) {
        return FolderTransferCollection.defaultCollection().listIterator(index);
    }

    @Override
    public List<Transfer> subList(int fromIndex, int toIndex) {
        return FolderTransferCollection.defaultCollection().subList(fromIndex, toIndex);
    }

    @Override
    public boolean containsAll(java.util.Collection<?> c) {
        return FolderTransferCollection.defaultCollection().containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return FolderTransferCollection.defaultCollection().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return FolderTransferCollection.defaultCollection().toArray(a);
    }

    public void save() {
        if (this.isLocked()) {
            log.debug((Object)"Do not write locked collection");
            return;
        }
        FolderTransferCollection.defaultCollection().save();
    }

    @Override
    public void load() throws AccessDeniedException {
        this.lock();
        try {
            FolderTransferCollection favorites = FolderTransferCollection.defaultCollection();
            if (this.file.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Found queue file %s", this.file));
                }
                favorites.load(this.reader.readCollection(this.file));
                this.trash();
            } else {
                favorites.load();
            }
        }
        finally {
            this.unlock();
        }
        super.load();
    }

    protected void trash() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Moving deprecated queue file to Trash");
        }
        try {
            LocalTrashFactory.get().trash(this.file);
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure trashing bookmark %s %s", this.file, e.getMessage()));
        }
    }

    public synchronized int numberOfRunningTransfers() {
        return FolderTransferCollection.defaultCollection().numberOfRunningTransfers();
    }

    public synchronized TransferProgress getProgress() {
        return FolderTransferCollection.defaultCollection().getProgress();
    }
}

