/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class FolderBookmarkCollection
extends AbstractFolderHostCollection {
    private static final Logger log = Logger.getLogger(FolderBookmarkCollection.class);
    private final Preferences preferences = PreferencesFactory.get();
    private static final FolderBookmarkCollection FAVORITES_COLLECTION = new FolderBookmarkCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "Bookmarks")){
        private static final long serialVersionUID = 6302021296403107371L;

        @Override
        public void collectionItemAdded(Host bookmark) {
            bookmark.setWorkdir(null);
            super.collectionItemAdded(bookmark);
        }
    };
    private static final String DEFAULT_PREFIX = "bookmark";
    private static final long serialVersionUID = -675342412129904735L;
    private final String prefix;

    public static FolderBookmarkCollection favoritesCollection() {
        return FAVORITES_COLLECTION;
    }

    public FolderBookmarkCollection(Local f) {
        this(f, DEFAULT_PREFIX);
    }

    public FolderBookmarkCollection(Local f, String prefix) {
        super(f);
        this.prefix = String.format("%s.", prefix);
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        try {
            if (this.isLocked()) {
                log.debug((Object)"Skip indexing collection while loading");
            } else {
                this.index();
            }
        }
        finally {
            super.collectionItemAdded(bookmark);
        }
    }

    @Override
    public void collectionItemRemoved(Host bookmark) {
        try {
            this.preferences.deleteProperty(String.format("%s%s", this.prefix, bookmark.getUuid()));
        }
        finally {
            super.collectionItemRemoved(bookmark);
        }
    }

    private void index() {
        this.lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                this.preferences.setProperty(String.format("%s%s", this.prefix, ((Host)this.get(i)).getUuid()), i);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void save() {
        this.index();
    }

    @Override
    protected void load(Collection<Host> c) {
        super.load(c);
        this.index();
        this.sort();
        for (Host bookmark : this) {
            this.save(bookmark);
        }
        this.collectionLoaded();
    }

    @Override
    protected synchronized void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return Integer.compare(FolderBookmarkCollection.this.preferences.getInteger(String.format("%s%s", FolderBookmarkCollection.this.prefix, o1.getUuid())), FolderBookmarkCollection.this.preferences.getInteger(String.format("%s%s", FolderBookmarkCollection.this.prefix, o2.getUuid())));
            }
        });
    }
}

