/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DAVMetadataFeature
implements Headers {
    private static final Logger log = Logger.getLogger(DAVMetadataFeature.class);
    private final DAVSession session;

    public DAVMetadataFeature(DAVSession session) {
        this.session = session;
    }

    public Map<String, String> getDefault(Local local) {
        return PreferencesFactory.get().getMap("webdav.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        try {
            List resources = ((DAVClient)((Object)this.session.getClient())).list(new DAVPathEncoder().encode(file));
            Iterator iterator = resources.iterator();
            if (iterator.hasNext()) {
                DavResource resource = (DavResource)iterator.next();
                return resource.getCustomProps();
            }
            return Collections.emptyMap();
        }
        catch (SardineException e) {
            try {
                throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            catch (InteroperabilityException | NotfoundException i) {
                log.warn((Object)String.format("Failure to obtain attributes of %s. %s", file, i));
                return Collections.emptyMap();
            }
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }

    public void setMetadata(Path file, Map<String, String> metadata) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write metadata %s for file %s", metadata, file));
        }
        try {
            ((DAVClient)((Object)this.session.getClient())).setCustomProps(new DAVPathEncoder().encode(file), metadata, Collections.emptyList());
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }
}

