/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2LargeUploadService
extends HttpUploadFeature<BaseB2Response, MessageDigest> {
    private static final Logger log = Logger.getLogger(B2LargeUploadService.class);
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;
    private final Long partSize;
    private final Integer concurrency;
    private static final String X_BZ_INFO_LARGE_FILE_SHA1 = "large_file_sha1";
    private Write<BaseB2Response> writer;

    public B2LargeUploadService(B2Session session, B2FileidProvider fileid, Write<BaseB2Response> writer, Long partSize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.fileid = fileid;
        this.writer = writer;
        this.partSize = partSize;
        this.concurrency = concurrency;
    }

    public BaseB2Response upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"largeupload", (int)this.concurrency);
        try {
            String fileid;
            ArrayList<Object> completed = new ArrayList<Object>();
            HashMap<String, String> fileinfo = new HashMap<String, String>(status.getMetadata());
            Checksum checksum = status.getChecksum();
            if (Checksum.NONE != checksum) {
                switch (checksum.algorithm) {
                    case sha1: {
                        fileinfo.put(X_BZ_INFO_LARGE_FILE_SHA1, status.getChecksum().hash);
                    }
                }
            }
            if (null != status.getTimestamp()) {
                fileinfo.put("src_last_modified_millis", String.valueOf(status.getTimestamp()));
            }
            if (status.isAppend()) {
                B2LargeUploadPartService partService = new B2LargeUploadPartService(this.session, this.fileid);
                List<B2FileInfoResponse> uploads = partService.find(file);
                if (uploads.isEmpty()) {
                    fileid = ((B2ApiClient)this.session.getClient()).startLargeFileUpload(this.fileid.getFileid(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(file), status.getMime(), fileinfo).getFileId();
                } else {
                    fileid = uploads.iterator().next().getFileId();
                    completed.addAll(partService.list(fileid));
                }
            } else {
                fileid = ((B2ApiClient)this.session.getClient()).startLargeFileUpload(this.fileid.getFileid(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(file), status.getMime(), fileinfo).getFileId();
            }
            long size = status.getLength() + status.getOffset();
            ArrayList<Future<B2UploadPartResponse>> parts = new ArrayList<Future<B2UploadPartResponse>>();
            long remaining = status.getLength();
            long offset = 0L;
            int partNumber = 1;
            while (remaining > 0L) {
                boolean bl = false;
                if (status.isAppend()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Determine if part number %d can be skipped", partNumber));
                    }
                    for (B2UploadPartResponse b2UploadPartResponse : completed) {
                        if (!b2UploadPartResponse.getPartNumber().equals(partNumber)) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip completed part number %d", partNumber));
                        }
                        bl = true;
                        offset += b2UploadPartResponse.getContentLength().longValue();
                        break;
                    }
                }
                if (!bl) {
                    Long l = Math.min(Math.max(size / 10000L, this.partSize), remaining);
                    parts.add(this.submit(pool, file, local, throttle, listener, status, partNumber, offset, l, callback));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Part %s submitted with size %d and offset %d", partNumber, l, offset));
                    }
                    remaining -= l.longValue();
                    offset += l.longValue();
                }
                ++partNumber;
            }
            try {
                for (Future future : parts) {
                    completed.add(future.get());
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"Part upload failed with interrupt failure");
                status.setCanceled();
                throw new ConnectionCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                if (e.getCause() instanceof BackgroundException) {
                    throw (BackgroundException)e.getCause();
                }
                throw new DefaultExceptionMappingService().map(e.getCause());
            }
            finally {
                pool.shutdown(false);
            }
            completed.sort(new Comparator<B2UploadPartResponse>(){

                @Override
                public int compare(B2UploadPartResponse o1, B2UploadPartResponse o2) {
                    return o1.getPartNumber().compareTo(o2.getPartNumber());
                }
            });
            ArrayList<String> checksums = new ArrayList<String>();
            for (B2UploadPartResponse b2UploadPartResponse : completed) {
                checksums.add(b2UploadPartResponse.getContentSha1());
            }
            B2FinishLargeFileResponse b2FinishLargeFileResponse = ((B2ApiClient)this.session.getClient()).finishLargeFileUpload(fileid, checksums.toArray(new String[checksums.size()]));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Finished large file upload %s with %d parts", file, completed.size()));
            }
            status.setComplete();
            return b2FinishLargeFileResponse;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    private Future<B2UploadPartResponse> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final int partNumber, final Long offset, final Long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        return pool.execute((Callable)new DefaultRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<B2UploadPartResponse>(){

            public B2UploadPartResponse call() throws BackgroundException {
                if (overall.isCanceled()) {
                    throw new TransferCanceledException();
                }
                final TransferStatus status = new TransferStatus().length(length.longValue()).skip(offset.longValue());
                status.setHeader(overall.getHeader());
                status.setNonces(overall.getNonces());
                status.setChecksum(B2LargeUploadService.this.writer.checksum(file).compute(local.getInputStream(), status));
                status.setSegment(true);
                status.setPart(Integer.valueOf(partNumber));
                return (B2UploadPartResponse)B2LargeUploadService.super.upload(file, local, throttle, listener, status, (StreamCancelation)overall, new StreamProgress(){

                    public void progress(long bytes) {
                        status.progress(bytes);
                        overall.progress(bytes);
                    }

                    public void setComplete() {
                        status.setComplete();
                    }
                }, callback);
            }
        }, overall));
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

