/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoOutputStream;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoAttributesFeature;
import ch.cyberduck.core.cryptomator.features.CryptoChecksumCompute;
import ch.cyberduck.core.cryptomator.features.CryptoFindFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.cryptomator.cryptolib.api.Cryptor;

public class CryptoWriteFeature<Reply>
implements Write<Reply> {
    private final Session<?> session;
    private final Write<Reply> proxy;
    private final Find finder;
    private final AttributesFinder attributes;
    private final CryptoVault vault;

    public CryptoWriteFeature(Session<?> session, Write<Reply> proxy, CryptoVault vault) {
        this(session, proxy, new CryptoFindFeature(session, (Find)new DefaultFindFeature(session), vault), new CryptoAttributesFeature(session, (AttributesFinder)new DefaultAttributesFinderFeature(session), vault), vault);
    }

    public CryptoWriteFeature(Session<?> session, Write<Reply> proxy, Find finder, AttributesFinder attributes, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.finder = finder;
        this.attributes = attributes;
        this.vault = vault;
    }

    public StatusOutputStream<Reply> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.writeEncrypted(this.vault.encrypt(this.session, file), status, callback);
    }

    public StatusOutputStream<Reply> writeEncrypted(Path encrypted, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            StatusOutputStream out;
            Cryptor cryptor = this.vault.getCryptor();
            if (status.getOffset() == 0L) {
                out = this.proxy.write(encrypted, new TransferStatus(status).length(this.vault.toCiphertextSize(status.getLength())).withMime(null), callback);
                out.write(status.getHeader().array());
            } else {
                out = this.proxy.write(encrypted, new TransferStatus(status).length(this.vault.toCiphertextSize(status.getLength()) - (long)cryptor.fileHeaderCryptor().headerSize()).skip(this.vault.toCiphertextSize(status.getOffset())).withMime(null), callback);
            }
            return new CryptoOutputStream(out, cryptor, cryptor.fileHeaderCryptor().decryptHeader(status.getHeader()), status.getNonces(), this.vault.numberOfChunks(status.getOffset()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(this.vault.encrypt(this.session, file))) {
            PathAttributes attributes = this.attributes.withCache(cache).find(this.vault.encrypt(this.session, file));
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return this.proxy.temporary();
    }

    public boolean random() {
        return this.proxy.random();
    }

    public ChecksumCompute checksum(Path file) {
        return new CryptoChecksumCompute(this.proxy.checksum(file), this.vault);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoWriteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

