/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;

public class CryptoTimestampFeature
implements Timestamp {
    private final Session<?> session;
    private final Timestamp proxy;
    private final CryptoVault vault;

    public CryptoTimestampFeature(Session<?> session, Timestamp proxy, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.vault = vault;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        this.proxy.setTimestamp(this.vault.encrypt(this.session, file), modified);
    }

    public Long getDefault(Local file) {
        return this.proxy.getDefault(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoTimestampFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

