/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.http.ProtocolException;

public abstract class HttpRange {
    private static final String REGEX_BOUNDED_REQUEST_RANGE = "bytes=[0-9]+-[0-9]+";
    private static final String REGEX_UNBOUNDED_REQUEST_RANGE = "bytes=[0-9]+-";
    private static final String REGEX_CONTENT_RANGE = "bytes [0-9]+-[0-9]+/[0-9]+";
    private static final int PART_COUNT_UNBOUNDED_RANGE = 1;
    private static final int PART_COUNT_BOUNDED_RANGE = 2;
    private static final int PART_COUNT_CONTENT_RANGE = 3;
    private static final String FMT_ERROR_MATCHING_REQUEST_RANGE = "Invalid Range format, expected one of: [bytes=<startInclusive>-<endInclusive>,bytes=<startInclusive>-], got: %s";
    private final long startInclusive;
    private final Long endInclusive;
    private final Long size;

    HttpRange(long startInclusive, Long endInclusive, Long size) {
        if (null != endInclusive && startInclusive > endInclusive) {
            throw new IllegalArgumentException("<start> must not be greater than <end>");
        }
        if (size != null) {
            if (endInclusive == null) {
                throw new IllegalArgumentException("<end> must be present if size is present");
            }
            if (size < 0L) {
                throw new IllegalArgumentException("<size> must not be less than zero");
            }
            if (size < 1L + endInclusive - startInclusive) {
                throw new IllegalArgumentException("<size> must not be less than the bytes defined by <start> and <end>");
            }
        }
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
        this.size = size;
    }

    long getStartInclusive() {
        return this.startInclusive;
    }

    Long getEndInclusive() {
        return this.endInclusive;
    }

    Long getSize() {
        return this.size;
    }

    long contentLength() {
        return 1L + this.endInclusive - this.startInclusive;
    }

    static <T extends HttpRange> T fromContentLength(Class<T> klass, long contentLength) {
        if (klass.equals(BoundedRequest.class)) {
            return (T)new BoundedRequest(0L, contentLength - 1L);
        }
        if (klass.equals(Response.class)) {
            return (T)new Response(0L, contentLength - 1L, contentLength);
        }
        throw new IllegalArgumentException(String.format("Cannot recognize HttpRange class: [%s]", klass));
    }

    protected abstract boolean matches(HttpRange var1);

    public abstract String render();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRange)) {
            return false;
        }
        HttpRange that = (HttpRange)o;
        return new EqualsBuilder().append(this.startInclusive, that.startInclusive).append((Object)this.endInclusive, (Object)that.endInclusive).append((Object)this.size, (Object)that.size).build();
    }

    public int hashCode() {
        return Objects.hash(this.startInclusive, this.endInclusive, this.size);
    }

    public abstract String toString();

    static Request parseRequestRange(String requestRange) throws ProtocolException {
        Validate.notNull((Object)requestRange, (String)"Request Range must not be null", (Object[])new Object[0]);
        boolean boundedMatch = requestRange.matches(REGEX_BOUNDED_REQUEST_RANGE);
        boolean unboundedMatch = requestRange.matches(REGEX_UNBOUNDED_REQUEST_RANGE);
        if (!boundedMatch && !unboundedMatch) {
            throw new ProtocolException(String.format(FMT_ERROR_MATCHING_REQUEST_RANGE, requestRange));
        }
        String[] bounds = StringUtils.split((String)StringUtils.removeStart((String)requestRange, (String)"bytes="), (String)"-");
        if (boundedMatch) {
            if (bounds.length != 2) {
                throw new ProtocolException(String.format(FMT_ERROR_MATCHING_REQUEST_RANGE, requestRange));
            }
            return new BoundedRequest(Long.parseUnsignedLong(bounds[0]), Long.parseUnsignedLong(bounds[1]));
        }
        if (unboundedMatch && bounds.length != 1) {
            throw new ProtocolException(String.format(FMT_ERROR_MATCHING_REQUEST_RANGE, requestRange));
        }
        return new UnboundedRequest(Long.parseUnsignedLong(bounds[0]));
    }

    static Response parseContentRange(String contentRange) throws ProtocolException {
        Validate.notNull((Object)contentRange, (String)"Content Range must not be null", (Object[])new Object[0]);
        if (!contentRange.matches(REGEX_CONTENT_RANGE)) {
            String message = String.format("Invalid content-range format, expected: [bytes <startInclusive>-<endInclusive>/<size>], got: %s", contentRange);
            throw new ProtocolException(message);
        }
        String[] boundsAndSize = StringUtils.split((String)StringUtils.removeStart((String)contentRange, (String)"bytes "), (String)"-/");
        if (boundsAndSize.length != 3) {
            throw new ProtocolException(String.format("Malformed Range value, got: %s", contentRange));
        }
        return new Response(Long.parseUnsignedLong(boundsAndSize[0]), Long.parseUnsignedLong(boundsAndSize[1]), Long.parseUnsignedLong(boundsAndSize[2]));
    }

    public static final class Response
    extends HttpRange {
        public Response(long startInclusive, long endInclusive, long size) {
            super(startInclusive, endInclusive, size);
        }

        @Override
        protected boolean matches(HttpRange other) {
            Validate.notNull((Object)other, (String)"Compared HttpRange must not be null", (Object[])new Object[0]);
            boolean matchingStart = Objects.equals(this.getStartInclusive(), other.startInclusive);
            boolean matchingEnd = Objects.equals(this.getEndInclusive(), other.endInclusive);
            boolean matchingSize = Objects.equals(this.getSize(), other.size);
            if (other.size == null) {
                if (other.endInclusive == null) {
                    return matchingStart;
                }
                return matchingStart && matchingEnd;
            }
            return matchingStart && matchingEnd && matchingSize;
        }

        @Override
        public String render() {
            return String.format("bytes %d-%d/%d", this.getStartInclusive(), this.getEndInclusive(), this.getSize());
        }

        @Override
        public String toString() {
            return "HttpRange.Response{startInclusive=" + this.getStartInclusive() + ", endInclusive=" + this.getEndInclusive() + ", size=" + this.getSize() + '}';
        }
    }

    public static final class BoundedRequest
    extends Request {
        public BoundedRequest(long startInclusive, long endInclusive) {
            super(startInclusive, endInclusive, null);
        }

        @Override
        protected boolean matches(HttpRange other) {
            Validate.notNull((Object)other, (String)"Compared HttpRange must not be null", (Object[])new Object[0]);
            boolean matchingStart = Objects.equals(this.getStartInclusive(), other.startInclusive);
            boolean matchingEnd = Objects.equals(this.getEndInclusive(), other.endInclusive);
            if (other.endInclusive != null) {
                return matchingStart && matchingEnd;
            }
            return matchingStart;
        }

        @Override
        public String render() {
            return String.format("bytes=%d-%d", this.getStartInclusive(), this.getEndInclusive());
        }

        @Override
        public String toString() {
            return "HttpRange.BoundedRequest{startInclusive=" + this.getStartInclusive() + ", endInclusive=" + this.getEndInclusive() + '}';
        }
    }

    public static final class UnboundedRequest
    extends Request {
        public UnboundedRequest(long startInclusive) {
            super(startInclusive, null, null);
        }

        @Override
        protected boolean matches(HttpRange other) {
            Validate.notNull((Object)other, (String)"Compared HttpRange must not be null", (Object[])new Object[0]);
            return Objects.equals(this.getStartInclusive(), other.startInclusive);
        }

        @Override
        public String render() {
            return String.format("bytes=%d-", this.getStartInclusive());
        }

        @Override
        public String toString() {
            return "HttpRange.UnboundedRequest{startInclusive=" + this.getStartInclusive() + ", endInclusive=" + this.getEndInclusive() + '}';
        }
    }

    static abstract class Request
    extends HttpRange {
        Request(long startInclusive, Long endInclusive, Long size) {
            super(startInclusive, endInclusive, size);
        }
    }
}

