/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.exception.MantaEncryptionException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class EncryptionType {
    public static final EncryptionType CLIENT = new EncryptionType("client", 1, 1);
    private static final Map<String, EncryptionType> SUPPORTED_ENCRYPTION_TYPES = Collections.singletonMap(EncryptionType.CLIENT.name, CLIENT);
    private final String name;
    private final int minVersionSupported;
    private final int maxVersionSupported;
    private final String id;

    private EncryptionType(String name, int minVersionSupported, int maxVersionSupported) {
        this.name = name;
        this.minVersionSupported = minVersionSupported;
        this.maxVersionSupported = maxVersionSupported;
        this.id = String.format("%s%s%d", name, "/", maxVersionSupported);
    }

    public static void validateEncryptionTypeIsSupported(String encryptionType) {
        int version;
        if (encryptionType == null) {
            String msg = "Invalid encryption type identifier must not be null";
            throw new MantaEncryptionException(msg);
        }
        if (StringUtils.isBlank((CharSequence)encryptionType)) {
            String msg = "Invalid encryption type identifier must not be blank";
            MantaEncryptionException e = new MantaEncryptionException(msg);
            e.setContextValue("malformedEncryptionType", String.format("[%s]", encryptionType));
            throw e;
        }
        String[] parts = encryptionType.split("/", 2);
        if (parts.length != 2) {
            String msg = "Invalid encryption type identifier specified: missing version separator.";
            MantaEncryptionException e = new MantaEncryptionException(msg);
            e.setContextValue("malformedEncryptionType", encryptionType);
            throw e;
        }
        EncryptionType type = SUPPORTED_ENCRYPTION_TYPES.get(parts[0]);
        if (type == null) {
            String msg = "Invalid encryption type identifier specified: Unknown type.";
            MantaEncryptionException e = new MantaEncryptionException(msg);
            e.setContextValue("malformedEncryptionType", encryptionType);
            e.setContextValue("type", parts[0]);
            throw e;
        }
        try {
            version = Integer.parseUnsignedInt(parts[1]);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid encryption type version identifier specified.";
            MantaEncryptionException mcee = new MantaEncryptionException(msg, e);
            mcee.setContextValue("malformedEncryptionType", encryptionType);
            mcee.setContextValue("malformedVersionString", parts[1]);
            throw mcee;
        }
        if (version > type.maxVersionSupported) {
            String msg = "Encryption type version is greater than supported";
            MantaEncryptionException e = new MantaEncryptionException(msg);
            e.setContextValue("encryptionType", encryptionType);
            e.setContextValue("desiredVersion", version);
            e.setContextValue("minimumVersionSupported", type.minVersionSupported);
            e.setContextValue("maximumVersionSupported", type.maxVersionSupported);
            throw e;
        }
        if (version < type.maxVersionSupported) {
            String msg = "Encryption type version is less than supported";
            MantaEncryptionException e = new MantaEncryptionException(msg);
            e.setContextValue("encryptionType", encryptionType);
            e.setContextValue("desiredVersion", version);
            e.setContextValue("minimumVersionSupported", type.minVersionSupported);
            e.setContextValue("maximumVersionSupported", type.maxVersionSupported);
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionType)) {
            return false;
        }
        EncryptionType that = (EncryptionType)o;
        return this.minVersionSupported == that.minVersionSupported && this.maxVersionSupported == that.maxVersionSupported && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.minVersionSupported, this.maxVersionSupported);
    }

    public String toString() {
        return this.id;
    }
}

