/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.util.NotThreadSafe;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.collections4.map.PredicatedMap;
import org.apache.commons.lang3.builder.ToStringBuilder;

@NotThreadSafe
public class MantaMetadata
implements Map<String, String>,
Cloneable,
Serializable {
    public static final String METADATA_PREFIX = "m-";
    public static final String ENCRYPTED_METADATA_PREFIX = "e-";
    static final char[] ILLEGAL_KEY_CHARS = "()<>@,;:</[]?={}\\ \n\t\r".toCharArray();
    private static final long serialVersionUID = -5828336629480323042L;
    private static final char ASCIICODE_32_SPACE = ' ';
    private final PredicatedMap<String, String> innerMap;

    public MantaMetadata(Map<? extends String, ? extends String> m) {
        this();
        this.putAll(m);
    }

    public MantaMetadata() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        HttpHeaderNameKeyPredicate keyPredicate = new HttpHeaderNameKeyPredicate();
        this.innerMap = PredicatedMap.predicatedMap((Map)map, (Predicate)keyPredicate, null);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new MantaMetadata(this);
    }

    public void removeAllEncrypted() {
        Set<Map.Entry<String, String>> set = this.entrySet();
        set.removeIf(entry -> ((String)entry.getKey()).startsWith(ENCRYPTED_METADATA_PREFIX));
    }

    public void delete(String key) {
        this.put(key, null);
    }

    @Override
    public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return (String)this.innerMap.merge((Object)key, (Object)value, remappingFunction);
    }

    @Override
    public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return (String)this.innerMap.compute((Object)key, remappingFunction);
    }

    @Override
    public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return (String)this.innerMap.computeIfPresent((Object)key, remappingFunction);
    }

    @Override
    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        return (String)this.innerMap.computeIfAbsent((Object)key, mappingFunction);
    }

    @Override
    public String replace(String key, String value) {
        return (String)this.innerMap.replace((Object)key, (Object)value);
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        return this.innerMap.replace((Object)key, (Object)oldValue, (Object)newValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.innerMap.remove(key, value);
    }

    @Override
    public String putIfAbsent(String key, String value) {
        return (String)this.innerMap.putIfAbsent((Object)key, (Object)value);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
        this.innerMap.replaceAll(function);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.innerMap.forEach(action);
    }

    @Override
    public String getOrDefault(Object key, String defaultValue) {
        return (String)this.innerMap.getOrDefault(key, (Object)defaultValue);
    }

    @Override
    public int hashCode() {
        return this.innerMap.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Map && this.innerMap.equals(object);
    }

    @Override
    public Collection<String> values() {
        return this.innerMap.values();
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public String remove(Object key) {
        return (String)this.innerMap.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public String get(Object key) {
        return (String)this.innerMap.get(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public String put(String key, String value) {
        return (String)this.innerMap.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> mapToCopy) {
        this.innerMap.putAll(mapToCopy);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.innerMap.entrySet();
    }

    public String toString() {
        String baseInfo = new ToStringBuilder((Object)this).append("innerMap", this.innerMap).toString();
        StringBuilder builder = new StringBuilder(baseInfo).append("\n");
        for (Map.Entry entry : this.innerMap.entrySet()) {
            builder.append(" [").append((String)entry.getKey()).append("] = [").append((String)entry.getValue()).append("]\n");
        }
        return builder.toString();
    }

    protected static class HttpHeaderNameKeyPredicate
    implements Predicate<String> {
        protected HttpHeaderNameKeyPredicate() {
        }

        public boolean evaluate(String object) {
            return object != null && !object.isEmpty() && !this.hasIllegalChars(object) && this.isIso88591(object) && this.validPrefix(object);
        }

        private boolean isIso88591(String input) {
            byte[] bytes = input.getBytes(StandardCharsets.ISO_8859_1);
            String result = new String(bytes, StandardCharsets.ISO_8859_1);
            return result.equals(input);
        }

        private boolean validPrefix(String input) {
            return input.toLowerCase(Locale.ENGLISH).startsWith(MantaMetadata.METADATA_PREFIX) || input.toLowerCase(Locale.ENGLISH).startsWith(MantaMetadata.ENCRYPTED_METADATA_PREFIX);
        }

        private boolean hasIllegalChars(String input) {
            char[] chars;
            for (char c : chars = input.toCharArray()) {
                if (this.isControlCharacter(c)) {
                    return true;
                }
                for (char illegalKeyChar : ILLEGAL_KEY_CHARS) {
                    if (c != illegalKeyChar) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isControlCharacter(char c) {
            char intVal = c;
            return intVal < ' ';
        }
    }
}

