/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;

public class TerminalPasswordCallback
implements PasswordCallback {
    private final Console console = new Console();
    private final TerminalPromptReader prompt;

    public TerminalPasswordCallback() {
        this.prompt = new InteractiveTerminalPromptReader();
    }

    public TerminalPasswordCallback(TerminalPromptReader prompt) {
        this.prompt = prompt;
    }

    @Override
    public void close(String input) {
        this.console.printf("%s%n", input);
    }

    @Override
    public Credentials prompt(Host bookmark, String title, String reason, LoginOptions options) throws LoginCanceledException {
        this.console.printf("%n%s", new StringAppender().append(title).append(reason));
        try {
            char[] input = this.console.readPassword("%n%s: ", options.getPasswordPlaceholder());
            Credentials credentials = new Credentials();
            credentials.setPassword(String.valueOf(input));
            return this.prompt(options, credentials);
        }
        catch (ConnectionCanceledException e) {
            throw new LoginCanceledException(e);
        }
    }

    protected Credentials prompt(LoginOptions options, Credentials credentials) {
        if (options.keychain) {
            if (!PreferencesFactory.get().getBoolean("keychain.secure")) {
                this.console.printf(String.format("WARNING! Passwords are stored in plain text in %s.", LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "credentials").getAbbreviatedPath()), new Object[0]);
            }
            credentials.setSaved(this.prompt.prompt(LocaleFactory.get().localize("Save password", "Credentials")));
        } else {
            credentials.setSaved(false);
        }
        return credentials;
    }
}

