/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class StoregateMultipartWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(StoregateMultipartWriteFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public StoregateMultipartWriteFeature(StoregateSession session, StoregateIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public StoregateMultipartWriteFeature(StoregateSession session, StoregateIdProvider fileid, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public HttpResponseOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            client = (StoregateApiClient)this.session.getClient();
            request = new HttpPost(String.format("%s/v4/upload/resumable", new Object[]{client.getBasePath()}));
            meta = new FileMetadata();
            meta.setId("");
            meta.setAttributes(0);
            meta.setFlags(0);
            meta.setLockId(status.getLockId() != null ? status.getLockId().toString() : "");
            meta.setFileName(file.getName());
            meta.setParentId(this.fileid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()));
            meta.setFileSize(0L);
            meta.setCreated(new DateTime(file.attributes().getCreationDate()));
            meta.setModified(new DateTime(file.attributes().getModificationDate()));
            request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(meta.getClass()).writeValueAsString((Object)meta), ContentType.create((String)"application/json", (String)"UTF-8")));
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            response = client.getClient().execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (response.containsHeader("Location")) {
                location = response.getFirstHeader("Location").getValue();
                proxy = new MultipartOutputStream(location, file, status);
                return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("storegate.upload.multipart.chunksize")))){

                    public VersionId getStatus() {
                        return proxy.getVersionId();
                    }
                };
            }
            throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final String location;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private Long offset = 0L;
        private VersionId versionId;

        public MultipartOutputStream(String location, Path file, TransferStatus status) {
            this.location = location;
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                final byte[] content = Arrays.copyOfRange(b, off, len);
                new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Void call() throws BackgroundException {
                        StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                        try {
                            HttpEntity entity = EntityBuilder.create().setBinary(content).build();
                            HttpPut put = new HttpPut(MultipartOutputStream.this.location);
                            put.setEntity(entity);
                            if (0L != MultipartOutputStream.this.overall.getLength() && 0 != content.length) {
                                HttpRange range = HttpRange.byLength((long)MultipartOutputStream.this.offset, (long)content.length);
                                String header = MultipartOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartOutputStream.this.overall.getOffset() + MultipartOutputStream.this.overall.getLength());
                                put.addHeader("Content-Range", String.format("bytes %s", header));
                            }
                            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 200: 
                                    case 201: {
                                        FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                        MultipartOutputStream.this.versionId = new VersionId(result.getId());
                                    }
                                    case 204: {
                                        MultipartOutputStream.this.offset = MultipartOutputStream.this.offset + (long)content.length;
                                        return null;
                                    }
                                    default: {
                                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                    }
                                }
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (IOException e) {
                            try {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)String.format("Cancel failed upload %s for %s", MultipartOutputStream.this.location, MultipartOutputStream.this.file));
                                }
                                HttpDelete delete = new HttpDelete(MultipartOutputStream.this.location);
                                client.getClient().execute((HttpUriRequest)delete);
                                return null;
                            }
                            catch (IOException ex) {
                                throw new DefaultIOExceptionMappingService().map(e);
                            }
                        }
                    }
                }, this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                try {
                    HttpPut put = new HttpPut(this.location);
                    put.addHeader("Content-Range", "bytes */0");
                    CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                this.versionId = new VersionId(result.getId());
                            }
                            case 204: {
                                return;
                            }
                            default: {
                                throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                            }
                        }
                    }
                    catch (BackgroundException e) {
                        throw new IOException(e);
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (IOException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Cancel failed upload %s for %s", this.location, this.file));
                    }
                    HttpDelete delete = new HttpDelete(this.location);
                    client.getClient().execute((HttpUriRequest)delete);
                }
                return;
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("id='").append(this.location).append('\'');
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }

        public VersionId getVersionId() {
            return this.versionId;
        }
    }
}

