/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;

public class StoregateAttributesFinderFeature
implements AttributesFinder {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateAttributesFinderFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            FilesApi files = new FilesApi((ApiClient)this.session.getClient());
            return this.toAttributes(files.filesGet_0(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map(e);
        }
    }

    public PathAttributes toAttributes(File f) throws BackgroundException {
        PathAttributes attrs = new PathAttributes();
        attrs.setVersionId(f.getId());
        attrs.setModificationDate(f.getModified().getMillis());
        attrs.setCreationDate(f.getCreated().getMillis());
        attrs.setSize(f.getSize().longValue());
        return attrs;
    }
}

