/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ExpiringObjectHolder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.PartialLoginFailureException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSDelegatingCopyFeature;
import ch.cyberduck.core.sds.SDSDelegatingMoveFeature;
import ch.cyberduck.core.sds.SDSDelegatingReadFeature;
import ch.cyberduck.core.sds.SDSDelegatingWriteFeature;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSDirectoryFeature;
import ch.cyberduck.core.sds.SDSEncryptionBulkFeature;
import ch.cyberduck.core.sds.SDSErrorResponseInterceptor;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSFindFeature;
import ch.cyberduck.core.sds.SDSHomeFinderService;
import ch.cyberduck.core.sds.SDSListService;
import ch.cyberduck.core.sds.SDSMoveFeature;
import ch.cyberduck.core.sds.SDSMultipartWriteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSProtocol;
import ch.cyberduck.core.sds.SDSQuotaFeature;
import ch.cyberduck.core.sds.SDSReadFeature;
import ch.cyberduck.core.sds.SDSSearchFeature;
import ch.cyberduck.core.sds.SDSSharesUrlProvider;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.SDSUrlProvider;
import ch.cyberduck.core.sds.SDSWriteFeature;
import ch.cyberduck.core.sds.UserAccountWrapper;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.JSON;
import ch.cyberduck.core.sds.io.swagger.client.api.AuthApi;
import ch.cyberduck.core.sds.io.swagger.client.api.ConfigApi;
import ch.cyberduck.core.sds.io.swagger.client.api.PublicApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.KeyValueEntry;
import ch.cyberduck.core.sds.io.swagger.client.model.LoginRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAccount;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.provider.HttpComponentsProvider;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.migcomponents.migbase64.Base64;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.InputStreamProvider;

public class SDSSession
extends HttpSession<SDSApiClient> {
    private static final Logger log = Logger.getLogger(SDSSession.class);
    public static final String SDS_AUTH_TOKEN_HEADER = "X-Sds-Auth-Token";
    public static final int DEFAULT_CHUNKSIZE = 16;
    protected SDSErrorResponseInterceptor retryHandler;
    protected OAuth2RequestInterceptor authorizationService;
    private final ExpiringObjectHolder<UserAccountWrapper> userAccount = new ExpiringObjectHolder(Long.valueOf(PreferencesFactory.get().getLong("sds.useracount.ttl")));
    private final ExpiringObjectHolder<UserKeyPairContainer> keyPair = new ExpiringObjectHolder(Long.valueOf(PreferencesFactory.get().getLong("sds.encryption.keys.ttl")));
    private final ExpiringObjectHolder<SoftwareVersionData> softwareVersion = new ExpiringObjectHolder(Long.valueOf(PreferencesFactory.get().getLong("sds.useracount.ttl")));
    private final List<KeyValueEntry> configuration = new ArrayList<KeyValueEntry>();
    private final SDSNodeIdProvider nodeid = new SDSNodeIdProvider(this);

    public SDSSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    protected SDSApiClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        switch (SDSProtocol.Authorization.valueOf(this.host.getProtocol().getAuthorization())) {
            case oauth: {
                this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).addInterceptorLast(new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) {
                        request.addHeader("Authorization", String.format("Basic %s", Base64.encodeToString((byte[])String.format("%s:%s", SDSSession.this.host.getProtocol().getOAuthClientId(), SDSSession.this.host.getProtocol().getOAuthClientSecret()).getBytes(StandardCharsets.UTF_8), (boolean)false)));
                    }
                }).build(), this.host).withRedirectUri(OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI.equals(this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : (Scheme.isURL((String)this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getOAuthRedirectUrl())));
                try {
                    this.authorizationService.withParameter("user_agent_info", Base64.encodeToString((byte[])InetAddress.getLocalHost().getHostName().getBytes(StandardCharsets.UTF_8), (boolean)false));
                }
                catch (UnknownHostException e) {
                    throw new DefaultIOExceptionMappingService().map((IOException)e);
                }
                configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
                configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
                configuration.addInterceptorLast(new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) {
                        request.removeHeaders(SDSSession.SDS_AUTH_TOKEN_HEADER);
                    }
                });
                break;
            }
            default: {
                this.retryHandler = new SDSErrorResponseInterceptor(this);
                configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
                configuration.addInterceptorLast((HttpRequestInterceptor)this.retryHandler);
            }
        }
        CloseableHttpClient apache = configuration.build();
        SDSApiClient client = new SDSApiClient(apache);
        int timeout = PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
        client.setConnectTimeout(timeout);
        client.setBasePath(new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getContext()));
        client.setHttpClient(ClientBuilder.newClient((Configuration)new ClientConfig().register((Object)new InputStreamProvider()).register(MultiPartFeature.class).register((Object)new JSON()).register(JacksonFeature.class).connectorProvider((ConnectorProvider)new HttpComponentsProvider(apache))));
        client.setUserAgent(new PreferencesUseragentProvider().get());
        return client;
    }

    public void login(Proxy proxy, LoginCallback controller, CancelCallback cancel) throws BackgroundException {
        Credentials credentials = this.host.getCredentials();
        String login = credentials.getUsername();
        String password = credentials.getPassword();
        switch (SDSProtocol.Authorization.valueOf(this.host.getProtocol().getAuthorization())) {
            case oauth: {
                this.authorizationService.setTokens(this.authorizationService.authorize(this.host, controller, cancel));
                break;
            }
            case radius: {
                Credentials additional = controller.prompt(this.host, LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Multi-Factor Authentication", (String)"S3"), new LoginOptions().icon(this.host.getProtocol().disk()).user(false).keychain(false));
                this.retryHandler.setTokens(login, password, this.login(controller, new LoginRequest().authType(LoginRequest.AuthTypeEnum.fromValue(this.host.getProtocol().getAuthorization())).login(login).password(additional.getPassword())));
                break;
            }
            default: {
                this.retryHandler.setTokens(login, password, this.login(controller, new LoginRequest().authType(LoginRequest.AuthTypeEnum.fromValue(this.host.getProtocol().getAuthorization())).login(login).password(password)));
            }
        }
        try {
            this.configuration.addAll(new ConfigApi((ApiClient)this.client).getSystemSettings("").getItems());
        }
        catch (ApiException e) {
            log.warn((Object)String.format("Ignore failure reading configuration. %s", new SDSExceptionMappingService().map(e).getDetail()));
        }
        try {
            UserAccount account = new UserApi((ApiClient)this.getClient()).getUserInfo(false, "", null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated as user %s", account));
            }
            credentials.setUsername(account.getLogin());
            this.userAccount.set((Object)new UserAccountWrapper(account));
            this.keyPair.set((Object)new UserApi((ApiClient)this.getClient()).getUserKeyPair(""));
            UserPrivateKey privateKey = new UserPrivateKey();
            UserKeyPairContainer keyPairContainer = (UserKeyPairContainer)this.keyPair.get();
            privateKey.setPrivateKey(keyPairContainer.getPrivateKeyContainer().getPrivateKey());
            privateKey.setVersion(keyPairContainer.getPrivateKeyContainer().getVersion());
            UserKeyPair userKeyPair = new UserKeyPair();
            userKeyPair.setUserPrivateKey(privateKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt to unlock private key %s", privateKey));
            }
            try {
                new TripleCryptKeyPair().unlock((PasswordCallback)controller, this.host, userKeyPair);
            }
            catch (LoginCanceledException e) {
                log.warn((Object)"Ignore cancel unlocking triple crypt private key pair");
            }
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map(e);
        }
        catch (ApiException e) {
            log.warn((Object)String.format("Ignore failure reading user key pair. %s", new SDSExceptionMappingService().map(e).getDetail()));
        }
        try {
            this.softwareVersion.set((Object)new PublicApi((ApiClient)this.getClient()).getSoftwareVersion(null));
        }
        catch (ApiException e) {
            log.warn((Object)String.format("Ignore failure reading version. %s", new SDSExceptionMappingService().map(e).getDetail()));
        }
    }

    private String login(LoginCallback controller, LoginRequest request) throws BackgroundException {
        try {
            try {
                return new AuthApi((ApiClient)this.client).login(request).getToken();
            }
            catch (ApiException e) {
                throw new SDSExceptionMappingService().map(e);
            }
        }
        catch (PartialLoginFailureException e) {
            Credentials additional = controller.prompt(this.host, this.host.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), e.getDetail(), new LoginOptions().icon(this.host.getProtocol().disk()).user(false).keychain(false));
            return this.login(controller, new LoginRequest().authType(LoginRequest.AuthTypeEnum.fromValue(this.host.getProtocol().getAuthorization())).password(additional.getPassword()));
        }
    }

    public UserAccountWrapper userAccount() throws BackgroundException {
        if (this.userAccount.get() == null) {
            try {
                this.userAccount.set((Object)new UserAccountWrapper(new UserApi((ApiClient)this.getClient()).getUserInfo(false, "", null)));
            }
            catch (ApiException e) {
                log.warn((Object)String.format("Failure updating user info. %s", e.getMessage()));
                throw new SDSExceptionMappingService().map(e);
            }
        }
        return (UserAccountWrapper)this.userAccount.get();
    }

    public UserKeyPairContainer keyPair() throws BackgroundException {
        if (this.keyPair.get() == null) {
            try {
                this.keyPair.set((Object)new UserApi((ApiClient)this.getClient()).getUserKeyPair(""));
            }
            catch (ApiException e) {
                log.warn((Object)String.format("Failure updating user key pair. %s", e.getMessage()));
                throw new SDSExceptionMappingService().map(e);
            }
        }
        return (UserKeyPairContainer)this.keyPair.get();
    }

    public SoftwareVersionData softwareVersion() throws BackgroundException {
        if (this.softwareVersion.get() == null) {
            try {
                this.softwareVersion.set((Object)new PublicApi((ApiClient)this.getClient()).getSoftwareVersion(null));
            }
            catch (ApiException e) {
                log.warn((Object)String.format("Failure updating user key pair. %s", e.getMessage()));
                throw new SDSExceptionMappingService().map(e);
            }
        }
        return (SoftwareVersionData)this.softwareVersion.get();
    }

    public List<KeyValueEntry> configuration() {
        return this.configuration;
    }

    protected void logout() {
        ((SDSApiClient)this.client).getHttpClient().close();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SDSListService(this, this.nodeid);
        }
        if (type == Read.class) {
            return (T)new SDSDelegatingReadFeature(this, this.nodeid, new SDSReadFeature(this, this.nodeid));
        }
        if (type == Write.class) {
            return (T)new SDSDelegatingWriteFeature(this, this.nodeid, (Write<VersionId>)new SDSWriteFeature(this, this.nodeid));
        }
        if (type == MultipartWrite.class) {
            return (T)new SDSDelegatingWriteFeature(this, this.nodeid, (Write<VersionId>)new SDSMultipartWriteFeature(this, this.nodeid));
        }
        if (type == Directory.class) {
            return (T)new SDSDirectoryFeature(this, this.nodeid);
        }
        if (type == Delete.class) {
            return (T)new SDSDeleteFeature(this, this.nodeid);
        }
        if (type == IdProvider.class) {
            return (T)this.nodeid;
        }
        if (type == Touch.class) {
            return (T)new SDSTouchFeature(this, this.nodeid);
        }
        if (type == Find.class) {
            return (T)new SDSFindFeature(this.nodeid);
        }
        if (type == AttributesFinder.class) {
            return (T)new SDSAttributesFinderFeature(this, this.nodeid);
        }
        if (type == Move.class) {
            return (T)new SDSDelegatingMoveFeature(this, this.nodeid, new SDSMoveFeature(this, this.nodeid));
        }
        if (type == Copy.class) {
            return (T)new SDSDelegatingCopyFeature(this, this.nodeid, new SDSCopyFeature(this, this.nodeid));
        }
        if (type == Bulk.class) {
            return (T)new SDSEncryptionBulkFeature(this, this.nodeid);
        }
        if (type == UrlProvider.class) {
            return (T)new SDSUrlProvider(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new SDSSharesUrlProvider(this, this.nodeid);
        }
        if (type == Quota.class) {
            return (T)new SDSQuotaFeature(this, this.nodeid);
        }
        if (type == Search.class) {
            return (T)new SDSSearchFeature(this, this.nodeid);
        }
        if (type == Home.class) {
            return (T)((Object)new SDSHomeFinderService(this, this.nodeid));
        }
        return (T)super._getFeature(type);
    }
}

