/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SDSNodeIdProvider
implements IdProvider {
    private static final Logger log = Logger.getLogger(SDSNodeIdProvider.class);
    private static final String ROOT_NODE_ID = "0";
    private final SDSSession session;
    private Cache<Path> cache = PathCache.empty();

    public SDSNodeIdProvider(SDSSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList list;
        Path found;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Return cached node %s for file %s", file.attributes().getVersionId(), file));
            }
            return file.attributes().getVersionId();
        }
        if (file.isRoot()) {
            return ROOT_NODE_ID;
        }
        if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)found.attributes().getVersionId())) {
            return this.set(file, found.attributes().getVersionId());
        }
        try {
            String type = file.isDirectory() ? "room:folder" : "file";
            NodeList nodes = new NodesApi((ApiClient)this.session.getClient()).getFsNodes(0, Long.parseLong(this.getFileid(file.getParent(), listener)), null, String.format("type:eq:%s|name:cn:%s", type, URIEncoder.encode((String)file.getName())), null, null, null, "", null);
            for (Node node : nodes.getItems()) {
                if (!node.getName().equals(file.getName())) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Return node %s for file %s", node.getId(), file));
                }
                return this.set(file, node.getId().toString());
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected String set(Path file, String id) {
        file.attributes().setVersionId(id);
        return id;
    }

    public boolean isEncrypted(Path file) {
        if (file.isRoot()) {
            return false;
        }
        if (file.getType().contains(AbstractPath.Type.triplecrypt)) {
            return true;
        }
        Path parent = file.getParent();
        if (parent.getType().contains(AbstractPath.Type.triplecrypt)) {
            return true;
        }
        Path container = new PathContainerService().getContainer(file);
        return container.getType().contains(AbstractPath.Type.triplecrypt);
    }

    public void setFileKey(TransferStatus status) throws BackgroundException {
        FileKey fileKey = TripleCryptConverter.toSwaggerFileKey(Crypto.generateFileKey());
        ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer.writeValue((OutputStream)out, (Object)fileKey);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        status.setFilekey(ByteBuffer.wrap(out.toByteArray()));
        status.setEncryption(new Encryption.Algorithm("AES256", null));
    }

    public SDSNodeIdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

