/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.servlets.gatekeeper.impl;

import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.servlets.gatekeeper.ClientInformation;
import org.jets3t.servlets.gatekeeper.UrlSigner;

public class DefaultUrlSigner
extends UrlSigner {
    protected ProviderCredentials credentials = null;
    protected S3Service s3Service = null;
    protected String s3BucketName = null;
    protected int secondsUntilExpiry = 0;
    public static final String TRANSACTION_ID_METADATA_NAME = "x-amz-gatekeeper-transaction-id";

    public DefaultUrlSigner(ServletConfig servletConfig) throws ServletException {
        super(servletConfig);
        String awsAccessKey = servletConfig.getInitParameter("AwsAccessKey");
        String awsSecretKey = servletConfig.getInitParameter("AwsSecretKey");
        boolean missingInitParam = false;
        String errorMessage = "Missing required servlet init parameters for UrlSigner: ";
        if (awsAccessKey == null || awsAccessKey.length() == 0) {
            errorMessage = errorMessage + "AwsAccessKey ";
            missingInitParam = true;
        }
        if (awsSecretKey == null || awsSecretKey.length() == 0) {
            errorMessage = errorMessage + "AwsSecretKey ";
            missingInitParam = true;
        }
        if (missingInitParam) {
            throw new ServletException(errorMessage);
        }
        this.credentials = new AWSCredentials(awsAccessKey, awsSecretKey);
        this.s3Service = new RestS3Service(this.credentials);
        String secondsToSign = servletConfig.getInitParameter("SecondsToSign");
        if (secondsToSign == null || secondsToSign.length() == 0) {
            throw new ServletException("Missing required servlet init parameters for DefaultUrlSigner: SecondsToSign");
        }
        try {
            this.secondsUntilExpiry = Integer.parseInt(secondsToSign);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Invalid servlet init param: SecondsToSign", (Throwable)e);
        }
        this.s3BucketName = servletConfig.getInitParameter("S3BucketName");
        if (this.s3BucketName == null || this.s3BucketName.length() == 0) {
            throw new ServletException("Missing required servlet init parameters for DefaultUrlSigner: S3BucketName");
        }
    }

    protected void updateObject(SignatureRequest signatureRequest, Properties messageProperties) throws S3ServiceException {
        String transactionId;
        signatureRequest.setBucketName(this.s3BucketName);
        Map objectMetadata = signatureRequest.getObjectMetadata();
        if (!objectMetadata.containsKey(TRANSACTION_ID_METADATA_NAME) && (transactionId = messageProperties.getProperty(TRANSACTION_ID_METADATA_NAME)) != null) {
            objectMetadata.put(TRANSACTION_ID_METADATA_NAME, transactionId);
        }
    }

    @Override
    public String signDelete(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        return this.s3Service.createSignedDeleteUrl(signatureRequest.getBucketName(), signatureRequest.getObjectKey(), this.calculateExpiryTime(this.secondsUntilExpiry), false);
    }

    @Override
    public String signGet(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        return this.s3Service.createSignedGetUrl(signatureRequest.getBucketName(), signatureRequest.getObjectKey(), this.calculateExpiryTime(this.secondsUntilExpiry), false);
    }

    @Override
    public String signHead(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        return this.s3Service.createSignedHeadUrl(signatureRequest.getBucketName(), signatureRequest.getObjectKey(), this.calculateExpiryTime(this.secondsUntilExpiry), false);
    }

    @Override
    public String signPut(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        return this.s3Service.createSignedPutUrl(signatureRequest.getBucketName(), signatureRequest.getObjectKey(), (Map<String, Object>)signatureRequest.getObjectMetadata(), this.calculateExpiryTime(this.secondsUntilExpiry), false);
    }

    @Override
    public String signGetAcl(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        long secondsSinceEpoch = this.calculateExpiryTime(this.secondsUntilExpiry).getTime() / 1000L;
        return this.s3Service.createSignedUrl("GET", signatureRequest.getBucketName(), signatureRequest.getObjectKey(), "acl", null, secondsSinceEpoch, false);
    }

    @Override
    public String signPutAcl(GatekeeperMessage requestMessage, ClientInformation clientInformation, SignatureRequest signatureRequest) throws S3ServiceException {
        this.updateObject(signatureRequest, requestMessage.getMessageProperties());
        long secondsSinceEpoch = this.calculateExpiryTime(this.secondsUntilExpiry).getTime() / 1000L;
        return this.s3Service.createSignedUrl("PUT", signatureRequest.getBucketName(), signatureRequest.getObjectKey(), "acl", (Map<String, Object>)signatureRequest.getObjectMetadata(), secondsSinceEpoch, false);
    }
}

