/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import com.github.sardine.DavResource;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class BrickTimestampFeature
extends DAVTimestampFeature {
    private static final String MS_NAMESPACE_URI = "http://brickftp.com/ns";
    private static final String MS_NAMESPACE_PREFIX = "s";
    private static final String MS_NAMESPACE_LASTMODIFIED = "provided_mtime";
    public static final QName LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE = new QName("http://brickftp.com/ns", "provided_mtime", "s");

    public BrickTimestampFeature(BrickSession session) {
        super((DAVSession)session);
    }

    protected Map<QName, String> getCustomProperties(DavResource resource, Long modified) {
        return Collections.singletonMap(LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE, new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("GMT")));
    }
}

