/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.log4j.Logger;

public class BrickPairingSchedulerFeature {
    private static final Logger log = Logger.getLogger(BrickPairingSchedulerFeature.class);
    private final BrickSession session;
    private final String token;
    private final Host host;
    private final CancelCallback cancel;
    protected final ScheduledThreadPool scheduler = new ScheduledThreadPool();

    public BrickPairingSchedulerFeature(BrickSession session, String token, Host host, CancelCallback cancel) {
        this.session = session;
        this.token = token;
        this.host = host;
        this.cancel = cancel;
    }

    public Credentials repeat(PasswordCallback callback) {
        this.scheduler.repeat(() -> {
            try {
                this.operate(callback);
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)"Cancel processing scheduled task. %s", (Throwable)e);
                this.shutdown();
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
                this.shutdown();
            }
        }, Long.valueOf(PreferencesFactory.get().getLong("brick.pairing.interval.ms")), TimeUnit.MILLISECONDS);
        return null;
    }

    private Credentials operate(PasswordCallback callback) throws BackgroundException {
        try {
            HttpPost resource = new HttpPost(String.format("https://app.files.com/api/rest/v1/sessions/pairing_key/%s", this.token));
            resource.setHeader("Accept", "application/json");
            resource.setHeader("Content-Type", "application/json");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Fetch credentials for paring key %s from %s", this.token, resource));
            }
            JsonObject json = (JsonObject)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<JsonObject>(){

                public JsonObject handleEntity(HttpEntity entity) throws IOException {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)entity.getContent(), (OutputStream)out);
                    JsonParser parser = new JsonParser();
                    return parser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(out.toByteArray()))).getAsJsonObject();
                }
            });
            Credentials credentials = this.host.getCredentials();
            if (json.has("username")) {
                if (StringUtils.isBlank((CharSequence)credentials.getUsername())) {
                    credentials.setUsername(json.getAsJsonPrimitive("username").getAsString());
                } else if (StringUtils.equals((CharSequence)credentials.getUsername(), (CharSequence)json.getAsJsonPrimitive("username").getAsString())) {
                    log.warn((Object)String.format("Mismatch of username. Previously authorized as %s and now paired as %s", credentials.getUsername(), json.getAsJsonPrimitive("username").getAsString()));
                    callback.close(null);
                    throw new LoginCanceledException();
                }
            } else {
                throw new LoginFailureException(String.format("Invalid response for pairing key %s", this.token));
            }
            if (!json.has("password")) {
                throw new LoginFailureException(String.format("Invalid response for pairing key %s", this.token));
            }
            credentials.setPassword(json.getAsJsonPrimitive("password").getAsString());
            if (json.has("nickname") && PreferencesFactory.get().getBoolean("brick.pairing.nickname.configure")) {
                this.host.setNickname(json.getAsJsonPrimitive("nickname").getAsString());
            }
            if (json.has("server") && PreferencesFactory.get().getBoolean("brick.pairing.hostname.configure")) {
                this.host.setHostname(URI.create(json.getAsJsonPrimitive("server").getAsString()).getHost());
            }
            callback.close(credentials.getUsername());
            return credentials;
        }
        catch (HttpResponseException e) {
            switch (e.getStatusCode()) {
                case 404: {
                    log.warn((Object)String.format("Missing login for pairing key %s", this.token));
                    this.cancel.verify();
                    return null;
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

