/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.updater;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPeriodicUpdateChecker
implements PeriodicUpdateChecker {
    private static final Logger log = Logger.getLogger(AbstractPeriodicUpdateChecker.class.getName());
    private final Controller controller;
    private final Duration delay;
    private final Timer timer = new Timer("updater", true);

    public AbstractPeriodicUpdateChecker(Controller controller) {
        this(controller, Duration.ofSeconds(PreferencesFactory.get().getLong("update.check.interval")));
    }

    public AbstractPeriodicUpdateChecker(Controller controller, Duration delay) {
        this.controller = controller;
        this.delay = delay;
    }

    @Override
    public void unregister() {
        this.timer.cancel();
    }

    @Override
    public Duration register() {
        log.info(String.format("Register update checker hook after %s", this.delay));
        try {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.format("Check for new updates after %s", AbstractPeriodicUpdateChecker.this.delay));
                    }
                    PreferencesFactory.get().setProperty("update.check.timestamp", System.currentTimeMillis());
                    AbstractPeriodicUpdateChecker.this.controller.invoke(new DefaultMainAction(){

                        @Override
                        public void run() {
                            AbstractPeriodicUpdateChecker.this.check(true);
                        }
                    });
                }
            }, this.delay.toMillis(), this.delay.toMillis());
            return this.delay;
        }
        catch (IllegalStateException e) {
            log.warning(String.format("Failure scheduling timer. %s", e.getMessage()));
            return Duration.ZERO;
        }
    }

    @Override
    public boolean hasUpdatePrivileges() {
        return true;
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

