/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import org.apache.log4j.Logger;

public final class BandwidthThrottle {
    private static final Logger log = Logger.getLogger(BandwidthThrottle.class);
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int bytesPerTick;
    private volatile boolean switching = false;
    private int availableBytes;
    private long nextTickTime;
    public static final int UNLIMITED = -1;
    private float rate = -1.0f;

    public BandwidthThrottle(float bytesPerSecond) {
        this.setRate(bytesPerSecond);
    }

    public BandwidthThrottle(float bytesPerSecond, boolean switching) {
        this.setRate(bytesPerSecond);
        this.setSwitching(switching);
    }

    public void setRate(float bytesPerSecond) {
        if (bytesPerSecond < 0.0f) {
            this.rate = -1.0f;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Set rate to %s bytes per second", Float.valueOf(bytesPerSecond)));
            }
            this.rate = bytesPerSecond;
            this.bytesPerTick = (int)(bytesPerSecond / 10.0f);
        }
        if (this.switching) {
            this.fixBytesPerTick(true);
        }
    }

    public float getRate() {
        return this.rate;
    }

    public void setSwitching(boolean switching) {
        log.debug((Object)("setSwitching:" + switching));
        if (this.switching != switching) {
            this.fixBytesPerTick(switching);
        }
        this.switching = switching;
    }

    private void fixBytesPerTick(boolean raise) {
        int newBytesPerTick = this.bytesPerTick;
        newBytesPerTick = raise ? (newBytesPerTick *= 2) : (newBytesPerTick /= 2);
        if (newBytesPerTick < 0) {
            newBytesPerTick = Integer.MAX_VALUE;
        }
        this.bytesPerTick = newBytesPerTick;
    }

    public synchronized int request(int desired) {
        if (-1.0f == this.rate) {
            return desired;
        }
        this.waitForBandwidth();
        int result = Math.min(desired, this.availableBytes);
        this.availableBytes -= result;
        return result;
    }

    private void waitForBandwidth() {
        while (true) {
            long now = System.currentTimeMillis();
            this.updateWindow(now);
            if (this.availableBytes != 0) break;
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Throttling bandwidth for %d milliseconds", this.nextTickTime - now));
                }
                Thread.sleep(this.nextTickTime - now);
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateWindow(long now) {
        if (now >= this.nextTickTime) {
            if (!this.switching || now / 1000L % 2L == 0L) {
                this.availableBytes = this.bytesPerTick;
                this.nextTickTime = now + 100L;
            } else {
                this.availableBytes = 0;
                long diff = 1000L - now % 1000L;
                this.nextTickTime = now + diff;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BandwidthThrottle)) {
            return false;
        }
        BandwidthThrottle that = (BandwidthThrottle)o;
        return Float.compare(that.rate, this.rate) == 0;
    }

    public int hashCode() {
        return this.rate != 0.0f ? Float.floatToIntBits(this.rate) : 0;
    }
}

