/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.EditOpenWorker;
import ch.cyberduck.core.editor.EditSaveWorker;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.log4j.Logger;

public abstract class AbstractEditor
implements Editor {
    private static final Logger log = Logger.getLogger(AbstractEditor.class);
    private boolean modified;
    private final Path remote;
    private final Local local;
    private final Application application;
    private Checksum checksum;
    private final SessionPool session;
    private final ProgressListener listener;
    private final ApplicationLauncher applicationLauncher;
    private final ApplicationFinder applicationFinder;
    private final NotificationService notification = NotificationServiceFactory.get();

    public AbstractEditor(Application application, SessionPool session, Path file, ProgressListener listener) {
        this(application, session, file, ApplicationLauncherFactory.get(), ApplicationFinderFactory.get(), listener);
    }

    public AbstractEditor(Application application, SessionPool session, Path file, ApplicationLauncher launcher, ApplicationFinder finder, ProgressListener listener) {
        this.applicationLauncher = launcher;
        this.applicationFinder = finder;
        this.application = application;
        this.remote = file.isSymbolicLink() && PreferencesFactory.get().getBoolean("editor.upload.symboliclink.resolve") ? file.getSymlinkTarget() : file;
        this.local = TemporaryFileServiceFactory.get().create(session.getHost().getUuid(), this.remote);
        this.session = session;
        this.listener = listener;
    }

    public Path getRemote() {
        return this.remote;
    }

    public Local getLocal() {
        return this.local;
    }

    public Application getApplication() {
        return this.application;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void delete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete edited file %s", this.local));
        }
        try {
            LocalTrashFactory.get().trash(this.local);
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure trashing edited file %s %s", this.local, e.getMessage()));
        }
    }

    @Override
    public Worker<Transfer> open(final ApplicationQuitCallback quit, TransferErrorCallback error, FileWatcherListener listener) {
        EditOpenWorker worker = new EditOpenWorker(this.session.getHost(), this, error, new ApplicationQuitCallback(){

            @Override
            public void callback() {
                quit.callback();
                AbstractEditor.this.close();
                AbstractEditor.this.delete();
            }
        }, this.listener, listener, this.notification){

            @Override
            public void cleanup(Transfer download) {
                try {
                    AbstractEditor.this.checksum = ChecksumComputeFactory.get(HashAlgorithm.md5).compute(AbstractEditor.this.local.getInputStream(), new TransferStatus());
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Error computing checksum for %s. %s", AbstractEditor.this.local, e.getDetail()));
                }
            }
        };
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Download file for edit %s", this.local));
        }
        return worker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void edit(ApplicationQuitCallback quit, FileWatcherListener listener) throws IOException {
        if (!this.applicationFinder.isInstalled(this.application)) {
            log.warn((Object)String.format("No editor application configured for %s", this.local));
            if (!this.applicationLauncher.open(this.local)) throw new IOException(String.format("Failed to open default application for %s", this.local.getName()));
            this.watch(this.local, listener);
            return;
        } else {
            if (!this.applicationLauncher.open(this.local, this.application, quit)) throw new IOException(String.format("Failed to open application %s for %s", this.application.getName(), this.local.getName()));
            this.watch(this.local, listener);
        }
    }

    protected abstract void watch(Local var1, FileWatcherListener var2) throws IOException;

    @Override
    public Worker<Transfer> save(TransferErrorCallback error) {
        Checksum current;
        try {
            this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Compute MD5 hash of {0}", "Status"), this.local.getName()));
            current = ChecksumComputeFactory.get(HashAlgorithm.md5).compute(this.local.getInputStream(), new TransferStatus());
        }
        catch (BackgroundException e) {
            log.warn((Object)String.format("Error computing checksum for %s. %s", this.local, e.getDetail()));
            return Worker.empty();
        }
        if (current.equals(this.checksum)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("File %s not modified with checksum %s", this.local, current));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Save new checksum %s for file %s", current, this.local));
            }
            this.checksum = current;
            EditSaveWorker worker = new EditSaveWorker(this.session.getHost(), this, error, this.listener, this.notification);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Upload changes for %s", this.local));
            }
            return worker;
        }
        return Worker.empty();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEditor that = (AbstractEditor)o;
        if (!Objects.equals(this.application, that.application)) {
            return false;
        }
        return Objects.equals(this.local, that.local);
    }

    public int hashCode() {
        int result = this.local != null ? this.local.hashCode() : 0;
        result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractEditor{");
        sb.append("application=").append(this.application);
        sb.append(", local=").append(this.local);
        sb.append('}');
        return sb.toString();
    }
}

