/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class Archive {
    private static final Logger log = Logger.getLogger(Archive.class);
    private final Preferences preferences = PreferencesFactory.get();
    public static final Archive TAR = new Archive("tar"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("tar archive", "Archive");
        }
    };
    public static final Archive TARGZ = new Archive("tar.gz"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("gzip compressed tar archive", "Archive");
        }

        @Override
        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "tgz"};
        }
    };
    public static final Archive TARBZ2 = new Archive("tar.bz2"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("bzip2 compressed tar archive", "Archive");
        }

        @Override
        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "tbz", "tbz2"};
        }
    };
    public static final Archive ZIP = new Archive("zip"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("ZIP archive", "Archive");
        }
    };
    public static final Archive GZIP = new Archive("gz"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("gzip compressed tar archive", "Archive");
        }

        @Override
        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "gzip"};
        }
    };
    public static final Archive BZ2 = new Archive("bz2"){

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("bzip2 compressed archive", "Archive");
        }

        @Override
        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "bz", "bzip2"};
        }
    };
    private final String identifier;

    public static Archive getDefault() {
        return Archive.forName(PreferencesFactory.get().getProperty("archive.default"));
    }

    public static Archive[] getKnownArchives() {
        return new Archive[]{TAR, TARGZ, TARBZ2, ZIP};
    }

    public static Archive forName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (Archive archive : Archive.getKnownArchives()) {
                for (String extension : archive.getExtensions()) {
                    if (!name.toLowerCase(Locale.ROOT).endsWith(extension.toLowerCase(Locale.ROOT))) continue;
                    return archive;
                }
            }
        }
        log.fatal((Object)String.format("Unknown archive %s", name));
        return null;
    }

    private Archive(String extension) {
        this.identifier = extension;
    }

    public String[] getExtensions() {
        return new String[]{this.getIdentifier()};
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public abstract String getDescription();

    public Path getArchive(List<Path> files) {
        if (files.size() == 0) {
            return null;
        }
        if (files.size() == 1) {
            return new Path(files.get(0).getParent(), String.format("%s.%s", files.get(0).getName(), this.getIdentifier()), EnumSet.of(AbstractPath.Type.file));
        }
        return new Path(files.get(0).getParent(), String.format("%s.%s", LocaleFactory.localizedString("Archive", "Archive"), this.getIdentifier()), EnumSet.of(AbstractPath.Type.file));
    }

    public List<Path> getExpanded(List<Path> files) {
        ArrayList<Path> expanded = new ArrayList<Path>();
        for (Path file : files) {
            expanded.add(new Path(file.getParent(), StringUtils.remove((String)file.getName(), (String)String.format(".%s", this.getIdentifier())), EnumSet.of(AbstractPath.Type.file)));
        }
        return expanded;
    }

    public String getTitle(List<Path> files) {
        Path archive = this.getArchive(files);
        if (null == archive) {
            return this.getIdentifier();
        }
        return archive.getName();
    }

    public String getCompressCommand(Path workdir, List<Path> files) {
        StringBuilder archive = new StringBuilder();
        if (files.size() == 1) {
            archive.append(this.escape(files.get(0).getAbsolute()));
        } else {
            archive.append(this.escape(files.get(0).getParent().getAbsolute())).append('/').append("Archive");
        }
        ArrayList<String> command = new ArrayList<String>();
        for (Path path : files) {
            command.add(this.escape(PathRelativizer.relativize(workdir.getAbsolute(), path.getAbsolute())));
        }
        return MessageFormat.format(this.preferences.getProperty(String.format("archive.command.create.%s", this.getIdentifier())), archive.toString(), StringUtils.join(command, (String)" "), this.escape(workdir.getAbsolute()));
    }

    public String getDecompressCommand(Path path) {
        return MessageFormat.format(this.preferences.getProperty(String.format("archive.command.expand.%s", this.getIdentifier())), this.escape(path.getAbsolute()), this.escape(path.getParent().getAbsolute()));
    }

    protected String escape(String path) {
        StringBuilder escaped = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (StringUtils.isAlphanumeric((CharSequence)String.valueOf(c)) || c == '/') {
                escaped.append(c);
                continue;
            }
            escaped.append("\\").append(c);
        }
        return escaped.toString();
    }

    public static boolean isArchive(String filename) {
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            for (Archive archive : Archive.getKnownArchives()) {
                for (String extension : archive.getExtensions()) {
                    if (!filename.endsWith(extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

