/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.utils.ServiceUtils;

public class S3WriteFeature
extends AbstractHttpWriteFeature<StorageObject>
implements Write<StorageObject> {
    private static final Logger log = Logger.getLogger(S3WriteFeature.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3MultipartService multipartService;
    private final Find finder;
    private final AttributesFinder attributes;

    public S3WriteFeature(S3Session session) {
        this(session, new S3DefaultMultipartService(session));
    }

    public S3WriteFeature(S3Session session, S3MultipartService multipartService) {
        this(session, multipartService, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public S3WriteFeature(S3Session session, S3MultipartService multipartService, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.multipartService = multipartService;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<StorageObject> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final S3Object object = this.getDetails(file, status);
        DelayedHttpEntityCallable<StorageObject> command = new DelayedHttpEntityCallable<StorageObject>(){

            public StorageObject call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    RequestEntityRestStorageService client = (RequestEntityRestStorageService)((Object)S3WriteFeature.this.session.getClient());
                    client.putObjectWithRequestEntityImpl(S3WriteFeature.this.containerService.getContainer(file).getName(), (StorageObject)object, (HttpEntity)entity, status.getParameters());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Saved object %s with checksum %s", file, object.getETag()));
                    }
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
                }
                return object;
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    protected S3Object getDetails(Path file, TransferStatus status) {
        Checksum checksum;
        S3Object object = new S3Object(this.containerService.getKey(file));
        String mime = status.getMime();
        if (StringUtils.isNotBlank((CharSequence)mime)) {
            object.setContentType(mime);
        }
        if (Checksum.NONE != (checksum = status.getChecksum())) {
            switch (checksum.algorithm) {
                case md5: {
                    object.setMd5Hash(ServiceUtils.fromHex((String)checksum.hash));
                    break;
                }
                case sha256: {
                    object.addMetadata("x-amz-content-sha256", checksum.hash);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)status.getStorageClass()) && !"STANDARD".equals(status.getStorageClass())) {
            object.setStorageClass(status.getStorageClass());
        }
        Encryption.Algorithm encryption = status.getEncryption();
        object.setServerSideEncryptionAlgorithm(encryption.algorithm);
        object.setServerSideEncryptionKmsKeyId(encryption.key);
        for (Map.Entry m : status.getMetadata().entrySet()) {
            object.addMetadata((String)m.getKey(), (String)m.getValue());
        }
        return object;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (length >= this.preferences.getLong("s3.upload.multipart.threshold") && this.preferences.getBoolean("s3.upload.multipart")) {
            try {
                List<MultipartUpload> upload = this.multipartService.find(file);
                if (!upload.isEmpty()) {
                    Long size = 0L;
                    for (MultipartPart completed : this.multipartService.list(upload.iterator().next())) {
                        size = size + completed.getSize();
                    }
                    return new Write.Append(size);
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn((Object)String.format("Ignore failure listing incomplete multipart uploads. %s", e.getDetail()));
            }
        }
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256);
    }
}

