/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3MultipartUploadService
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private static final Logger log = Logger.getLogger(S3MultipartUploadService.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3DefaultMultipartService multipartService;
    private Write<StorageObject> writer;
    private final Long partsize;
    private final Integer concurrency;

    public S3MultipartUploadService(S3Session session, Write<StorageObject> writer) {
        this(session, writer, PreferencesFactory.get().getLong("s3.upload.multipart.size"), PreferencesFactory.get().getInteger("s3.upload.multipart.concurrency"));
    }

    public S3MultipartUploadService(S3Session session, Write<StorageObject> writer, Long partsize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.multipartService = new S3DefaultMultipartService(session);
        this.writer = writer;
        this.partsize = partsize;
        this.concurrency = concurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        StorageObject storageObject;
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        MultipartUpload multipart = null;
        try {
            List<MultipartUpload> list;
            if (status.isAppend() && !(list = this.multipartService.find(file)).isEmpty()) {
                multipart = list.iterator().next();
            }
        }
        catch (AccessDeniedException | InteroperabilityException e) {
            log.warn((Object)String.format("Ignore failure listing incomplete multipart uploads. %s", e.getDetail()));
        }
        ArrayList<Object> completed = new ArrayList<Object>();
        if (null == multipart) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No pending multipart upload found");
            }
            S3Object object = new S3WriteFeature(this.session, new S3DisabledMultipartService()).getDetails(file, status);
            multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(this.containerService.getContainer(file).getName(), object);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
            }
        } else if (status.isAppend()) {
            completed.addAll(this.multipartService.list(multipart));
        }
        try {
            long size = status.getLength() + status.getOffset();
            ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
            long remaining = status.getLength();
            long offset = 0L;
            int partNumber = 1;
            while (remaining > 0L) {
                boolean bl = false;
                if (status.isAppend()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Determine if part number %d can be skipped", partNumber));
                    }
                    for (MultipartPart multipartPart : completed) {
                        if (!multipartPart.getPartNumber().equals(partNumber)) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip completed part number %d", partNumber));
                        }
                        bl = true;
                        offset += multipartPart.getSize().longValue();
                        break;
                    }
                }
                if (!bl) {
                    Long length = Math.min(Math.max(size / 9999L, this.partsize), remaining);
                    parts.add(this.submit(pool, file, local, throttle, listener, status, multipart, partNumber, offset, length, callback));
                    remaining -= length.longValue();
                    offset += length.longValue();
                }
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    completed.add(future.get());
                }
                catch (InterruptedException e) {
                    log.error((Object)"Part upload failed with interrupt failure");
                    status.setCanceled();
                    throw new ConnectionCanceledException((Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                    if (e.getCause() instanceof BackgroundException) {
                        throw (BackgroundException)e.getCause();
                    }
                    throw new BackgroundException(e.getCause());
                }
            }
            MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartCompleteUpload(multipart, completed);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Completed multipart upload for %s with %d parts and checksum %s", complete.getObjectKey(), completed.size(), complete.getEtag()));
            }
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                log.warn((Object)String.format("Skip checksum verification for %s with client side encryption enabled", file));
            } else {
                void var20_32;
                completed.sort((Comparator<Object>)new MultipartPart.PartNumberComparator());
                StringBuilder stringBuilder = new StringBuilder();
                for (MultipartPart multipartPart : completed) {
                    stringBuilder.append(multipartPart.getEtag());
                }
                String expected = String.format("%s-%d", ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(stringBuilder.toString(), new TransferStatus()), completed.size());
                if (complete.getEtag().startsWith("\"") && complete.getEtag().endsWith("\"")) {
                    String string = complete.getEtag().substring(1, complete.getEtag().length() - 1);
                } else {
                    String string = complete.getEtag();
                }
                if (!expected.equals(var20_32)) {
                    if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
                        throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", expected, var20_32));
                    }
                    log.warn((Object)String.format("Mismatch between MD5 hash %s of uploaded data and ETag %s returned by the server", expected, var20_32));
                }
            }
            status.setComplete();
            StorageObject storageObject2 = new StorageObject(this.containerService.getKey(file));
            storageObject2.setETag(complete.getEtag());
            storageObject = storageObject2;
        }
        catch (Throwable throwable) {
            try {
                pool.shutdown(false);
                throw throwable;
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
            }
        }
        pool.shutdown(false);
        return storageObject;
    }

    private Future<MultipartPart> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final MultipartUpload multipart, final int partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        return pool.execute((Callable)new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<MultipartPart>(){

            public MultipartPart call() throws BackgroundException {
                if (overall.isCanceled()) {
                    throw new TransferCanceledException();
                }
                HashMap<String, String> requestParameters = new HashMap<String, String>();
                requestParameters.put("uploadId", multipart.getUploadId());
                requestParameters.put("partNumber", String.valueOf(partNumber));
                final TransferStatus status = new TransferStatus().length(length).skip(offset).withParameters(requestParameters);
                status.setHeader(overall.getHeader());
                status.setNonces(overall.getNonces());
                switch (S3MultipartUploadService.this.session.getSignatureVersion()) {
                    case AWS4HMACSHA256: {
                        status.setChecksum(S3MultipartUploadService.this.writer.checksum(file).compute(local.getInputStream(), status));
                    }
                }
                status.setSegment(true);
                StorageObject part = (StorageObject)S3MultipartUploadService.super.upload(file, local, throttle, listener, status, (StreamCancelation)overall, new StreamProgress(){

                    public void progress(long bytes) {
                        status.progress(bytes);
                        overall.progress(bytes);
                    }

                    public void setComplete() {
                        status.setComplete();
                    }
                }, callback);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Received response %s for part number %d", part, partNumber));
                }
                return new MultipartPart(Integer.valueOf(partNumber), null == part.getLastModifiedDate() ? new Date(System.currentTimeMillis()) : part.getLastModifiedDate(), null == part.getETag() ? "" : part.getETag(), Long.valueOf(part.getContentLength()));
            }
        }, overall));
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

