/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.auth;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.s3.S3Session;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import org.apache.log4j.Logger;

public class AWSCredentialsConfigurator
implements CredentialsConfigurator {
    private static final Logger log = Logger.getLogger(AWSCredentialsConfigurator.class);
    private final AWSCredentialsProvider[] providers;

    public AWSCredentialsConfigurator(AWSCredentialsProvider ... providers) {
        this.providers = providers;
    }

    public Credentials configure(Host host) {
        Credentials credentials = new Credentials(host.getCredentials());
        if (S3Session.isAwsHostname(host.getHostname()) && !credentials.validate(host.getProtocol(), new LoginOptions(host.getProtocol()).password(false))) {
            for (AWSCredentialsProvider provider : this.providers) {
                try {
                    AWSCredentials c = provider.getCredentials();
                    credentials.setUsername(c.getAWSAccessKeyId());
                    credentials.setPassword(c.getAWSSecretKey());
                    if (!(c instanceof AWSSessionCredentials)) break;
                    credentials.setToken(((AWSSessionCredentials)c).getSessionToken());
                    break;
                }
                catch (SdkClientException e) {
                    log.debug((Object)String.format("Ignore failure loading credentials from provider %s", provider));
                }
            }
        }
        return credentials;
    }

    public void reload() {
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    public static AWSCredentialsProvider toAWSCredentialsProvider(final Credentials credentials) {
        return credentials.isTokenAuthentication() ? new AWSSessionCredentialsProvider(){

            public AWSSessionCredentials getCredentials() {
                return new AWSSessionCredentials(){

                    public String getSessionToken() {
                        return credentials.getToken();
                    }

                    public String getAWSAccessKeyId() {
                        return credentials.getUsername();
                    }

                    public String getAWSSecretKey() {
                        return credentials.getPassword();
                    }
                };
            }

            public void refresh() {
            }
        } : new AWSStaticCredentialsProvider(new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return credentials.getUsername();
            }

            public String getAWSSecretKey() {
                return credentials.getPassword();
            }
        });
    }
}

