/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.PermissionOverwrite;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ReadPermissionWorker
extends Worker<PermissionOverwrite> {
    private final List<Path> files;

    public ReadPermissionWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public PermissionOverwrite run(Session<?> session) throws BackgroundException {
        UnixPermission feature = session.getFeature(UnixPermission.class);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Path next : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            if (Permission.EMPTY == next.attributes().getPermission()) {
                next.attributes().setPermission(feature.getUnixPermission(next));
            }
            permissions.add(next.attributes().getPermission());
        }
        PermissionOverwrite overwrite = new PermissionOverwrite();
        Supplier<Stream<Permission>> supplier = permissions::stream;
        overwrite.user.read = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getUser, Permission.Action.read));
        overwrite.user.write = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getUser, Permission.Action.write));
        overwrite.user.execute = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getUser, Permission.Action.execute));
        overwrite.group.read = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getGroup, Permission.Action.read));
        overwrite.group.write = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getGroup, Permission.Action.write));
        overwrite.group.execute = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getGroup, Permission.Action.execute));
        overwrite.other.read = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getOther, Permission.Action.read));
        overwrite.other.write = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getOther, Permission.Action.write));
        overwrite.other.execute = ReadPermissionWorker.resolveOverwrite(ReadPermissionWorker.map(supplier, Permission::getOther, Permission.Action.execute));
        return overwrite;
    }

    private static Boolean resolveOverwrite(Supplier<Stream<Boolean>> implies) {
        Supplier<Stream> supplier = () -> ((Stream)implies.get()).distinct();
        return supplier.get().count() == 1L ? (Boolean)supplier.get().findAny().get() : null;
    }

    private static Supplier<Stream<Boolean>> map(Supplier<Stream<Permission>> permissions, Function<Permission, Permission.Action> selector, Permission.Action action) {
        return () -> ((Stream)permissions.get()).map(permission -> ((Permission.Action)((Object)((Object)((Object)selector.apply((Permission)permission))))).implies(action));
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Getting permission of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public PermissionOverwrite initialize() {
        return new PermissionOverwrite();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadPermissionWorker that = (ReadPermissionWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadPermissionWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

