/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultUploadFeature<Reply>
implements Upload<Reply> {
    private Write<Reply> writer;

    public DefaultUploadFeature(Write<Reply> writer) {
        this.writer = writer;
    }

    @Override
    public Reply upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        InputStream in = local.getInputStream();
        StatusOutputStream<Reply> out = this.writer.write(file, status, callback);
        new StreamCopier(status, status).withOffset(status.getOffset()).withLimit(status.getLength()).withListener(listener).transfer(in, (OutputStream)((Object)new ThrottledOutputStream((OutputStream)((Object)out), throttle)));
        return out.getStatus();
    }

    @Override
    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.writer.append(file, length, cache);
    }

    @Override
    public Upload<Reply> withWriter(Write<Reply> writer) {
        this.writer = writer;
        return this;
    }
}

