/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractSchedulerFeature<R>
implements Scheduler<R> {
    private static final Logger log = Logger.getLogger(AbstractSchedulerFeature.class);
    private final long period;
    private final ScheduledThreadPool scheduler = new ScheduledThreadPool();

    public AbstractSchedulerFeature(long period) {
        this.period = period;
    }

    protected abstract R operate(PasswordCallback var1, Path var2) throws BackgroundException;

    @Override
    public R repeat(PasswordCallback callback) {
        this.scheduler.repeat(() -> {
            try {
                this.operate(callback, null);
            }
            catch (BackgroundException e) {
                log.warn((Object)"Failure processing scheduled task. %s", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"Failure processing scheduled task. %s", (Throwable)e);
                this.shutdown();
            }
        }, this.period, TimeUnit.MILLISECONDS);
        return null;
    }

    @Override
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down scheduler thread pool");
        }
        this.scheduler.shutdown();
    }
}

