/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.StringUtils;

public class DefaultExcludes
extends Task {
    private String add = "";
    private String remove = "";
    private boolean defaultrequested = false;
    private boolean echo = false;
    private int logLevel = 1;

    @Override
    public void execute() throws BuildException {
        if (!this.defaultrequested && "".equals(this.add) && "".equals(this.remove) && !this.echo) {
            throw new BuildException("<defaultexcludes> task must set at least one attribute (echo=\"false\" doesn't count since that is the default");
        }
        if (this.defaultrequested) {
            DirectoryScanner.resetDefaultExcludes();
        }
        if (!"".equals(this.add)) {
            DirectoryScanner.addDefaultExclude(this.add);
        }
        if (!"".equals(this.remove)) {
            DirectoryScanner.removeDefaultExclude(this.remove);
        }
        if (this.echo) {
            StringBuilder message = new StringBuilder("Current Default Excludes:");
            message.append(StringUtils.LINE_SEP);
            for (String exclude : DirectoryScanner.getDefaultExcludes()) {
                message.append("  ");
                message.append(exclude);
                message.append(StringUtils.LINE_SEP);
            }
            this.log(message.toString(), this.logLevel);
        }
    }

    public void setDefault(boolean def) {
        this.defaultrequested = def;
    }

    public void setAdd(String add) {
        this.add = add;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }
}

