/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSDelegatingWriteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;

public class SDSTouchFeature
implements Touch<VersionId> {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private Write<VersionId> writer;

    public SDSTouchFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
        this.writer = new SDSDelegatingWriteFeature(session, nodeid, (Write<VersionId>)new SDSWriteFeature(session, nodeid));
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            if (this.nodeid.isEncrypted(file)) {
                this.nodeid.setFileKey(status);
            }
            StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
            out.close();
            return new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((VersionId)out.getStatus()).id));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create file {0}", (Throwable)e, file);
        }
    }

    public boolean isSupported(Path workdir) {
        if (workdir.isRoot()) {
            return false;
        }
        return new SDSPermissionsFeature(this.session, this.nodeid).containsRole(workdir, SDSPermissionsFeature.CREATE_ROLE);
    }

    public Touch<VersionId> withWriter(Write<VersionId> writer) {
        this.writer = writer;
        return this;
    }
}

