/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import java.util.HashMap;

public class SDSAttributesFinderFeature
implements AttributesFinder {
    public static final String KEY_CNT_DOWNLOADSHARES = "count_downloadshares";
    public static final String KEY_CNT_UPLOADSHARES = "count_uploadshares";
    public static final String KEY_ENCRYPTED = "encrypted";
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSAttributesFinderFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            Node node = new NodesApi((ApiClient)this.session.getClient()).getFsNode(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), "", null);
            return this.toAttributes(node);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(Node node) throws BackgroundException {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setRevision(node.getBranchVersion());
        attributes.setChecksum(Checksum.parse((String)node.getHash()));
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getMillis() : -1L);
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getMillis() : -1L);
        attributes.setSize(node.getSize().longValue());
        attributes.setPermission(this.toPermission(node));
        attributes.setAcl(this.toAcl(node));
        HashMap<String, String> custom = new HashMap<String, String>();
        if (null != node.getCntDownloadShares()) {
            custom.put(KEY_CNT_DOWNLOADSHARES, String.valueOf(node.getCntDownloadShares()));
        }
        if (null != node.getCntUploadShares()) {
            custom.put(KEY_CNT_UPLOADSHARES, String.valueOf(node.getCntUploadShares()));
        }
        custom.put(KEY_ENCRYPTED, String.valueOf(node.getIsEncrypted()));
        attributes.setCustom(custom);
        return attributes;
    }

    private Permission toPermission(Node node) throws BackgroundException {
        Permission permission = new Permission(Permission.Action.none, Permission.Action.none, Permission.Action.none);
        if (node.getIsEncrypted().booleanValue() && node.getType() == Node.TypeEnum.FILE) {
            if (null != this.session.keyPair()) {
                permission.setUser(permission.getUser().or(Permission.Action.read));
            }
        } else {
            permission.setUser(permission.getUser().or(Permission.Action.read));
        }
        switch (node.getType()) {
            case ROOM: 
            case FOLDER: {
                permission.setUser(permission.getUser().or(Permission.Action.execute));
            }
        }
        if (node.getPermissions().getChange().booleanValue()) {
            permission.setUser(permission.getUser().or(Permission.Action.write));
        }
        return permission;
    }

    private Acl toAcl(Node node) {
        Acl acl = new Acl();
        Acl.CanonicalUser user = new Acl.CanonicalUser();
        if (node.getPermissions().getManage().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.MANAGE_ROLE});
        }
        if (node.getPermissions().getRead().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.READ_ROLE});
        }
        if (node.getPermissions().getCreate().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
        }
        if (node.getPermissions().getChange().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CHANGE_ROLE});
        }
        if (node.getPermissions().getDelete().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DELETE_ROLE});
        }
        if (node.getPermissions().getManageDownloadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE});
        }
        if (node.getPermissions().getManageUploadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.UPLOAD_SHARE_ROLE});
        }
        return acl;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        this.nodeid.withCache((Cache)cache);
        return this;
    }
}

