/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Context;
import io.milton.context.Factory;
import io.milton.context.Registration;
import io.milton.context.RootContext;
import java.util.ArrayList;

public class BeanFactory
implements Factory {
    public static final String SCOPE_APP = "app";
    public static final String SCOPE_REQUEST = "request";
    private Class beanClass;
    private Class[] keyClasses;
    private String scope = "app";

    @Override
    public Class[] keyClasses() {
        return this.keyClasses;
    }

    @Override
    public String[] keyIds() {
        return null;
    }

    public Registration insert(RootContext context, Context requestContext) {
        Object o = this.instantiateBean();
        if (this.isRequestScope()) {
            return requestContext.put(o);
        }
        return context.put(o);
    }

    @Override
    public void init(RootContext context) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onRemove(Object item) {
    }

    public String getBeanClass() {
        return this.beanClass.getCanonicalName();
    }

    public void setBeanClass(String beanClass) {
        try {
            this.beanClass = Class.forName(beanClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(beanClass, ex);
        }
        if (this.keyClasses == null) {
            this.keyClasses = this.beanClass.getInterfaces();
        }
    }

    public String getKeyClasses() {
        String s = "";
        for (Class c : this.keyClasses) {
            s = s + c.getCanonicalName() + ",";
        }
        return s;
    }

    public void setKeyClasses(String keyClasses) {
        String[] arr = keyClasses.split(",");
        ArrayList list = new ArrayList();
        for (String s : arr) {
            try {
                Class<?> i = Class.forName(s);
                list.add(i);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(s, ex);
            }
        }
        this.keyClasses = new Class[list.size()];
        list.toArray(this.keyClasses);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (!scope.equals(SCOPE_APP) && !scope.equals(SCOPE_REQUEST)) {
            throw new RuntimeException("Scope attribute on BeanFactory must be app or request  not: " + scope);
        }
        this.scope = scope;
    }

    private Object instantiateBean() {
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isRequestScope() {
        return this.scope.equals(SCOPE_REQUEST);
    }
}

