/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.client.crypto.ByteRangeConversion;
import com.joyent.manta.client.crypto.EncryptedMetadataUtils;
import com.joyent.manta.client.crypto.EncryptingEntity;
import com.joyent.manta.client.crypto.EncryptionType;
import com.joyent.manta.client.crypto.MantaEncryptedObjectInputStream;
import com.joyent.manta.client.crypto.SecretKeyUtils;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.crypto.SupportedCiphersLookupMap;
import com.joyent.manta.client.crypto.SupportedHmacsLookupMap;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.DefaultsConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaConnectionContext;
import com.joyent.manta.http.MantaConnectionFactory;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.http.MantaHttpRequestFactory;
import com.joyent.manta.http.PlaintextByteRangePosition;
import com.joyent.manta.http.StandardHttpHelper;
import com.joyent.manta.http.entity.NoContentEntity;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionHttpHelper
extends StandardHttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionHttpHelper.class);
    private static final int MAX_METADATA_CIPHERTEXT_BASE64_SIZE = 4000;
    private final String encryptionKeyId;
    private final boolean permitUnencryptedDownloads;
    private final EncryptionAuthenticationMode encryptionAuthenticationMode;
    private final SecretKey secretKey;
    private final SupportedCipherDetails cipherDetails;

    @Deprecated
    public EncryptionHttpHelper(MantaConnectionContext connectionContext, MantaConnectionFactory connectionFactory, ConfigContext config) {
        this(connectionContext, config);
    }

    EncryptionHttpHelper(MantaConnectionContext connectionContext, ConfigContext config) {
        this(connectionContext, new MantaHttpRequestFactory(config.getMantaURL()), config);
    }

    public EncryptionHttpHelper(MantaConnectionContext connectionContext, MantaHttpRequestFactory requestFactory, ConfigContext config) {
        super(connectionContext, requestFactory, (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{config.verifyUploads(), true}), (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{config.downloadContinuations(), 0}));
        this.encryptionKeyId = (String)ObjectUtils.firstNonNull((Object[])new String[]{config.getEncryptionKeyId(), "unknown-key"});
        this.permitUnencryptedDownloads = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{config.permitUnencryptedDownloads(), false});
        this.encryptionAuthenticationMode = (EncryptionAuthenticationMode)((Object)ObjectUtils.firstNonNull((Object[])new EncryptionAuthenticationMode[]{config.getEncryptionAuthenticationMode(), EncryptionAuthenticationMode.DEFAULT_MODE}));
        this.cipherDetails = (SupportedCipherDetails)ObjectUtils.firstNonNull((Object[])new SupportedCipherDetails[]{(SupportedCipherDetails)SupportedCiphersLookupMap.INSTANCE.getWithCaseInsensitiveKey(config.getEncryptionAlgorithm()), DefaultsConfigContext.DEFAULT_CIPHER});
        if (config.getEncryptionPrivateKeyPath() != null) {
            Path keyPath = Paths.get(config.getEncryptionPrivateKeyPath(), new String[0]);
            try {
                this.secretKey = SecretKeyUtils.loadKeyFromPath(keyPath, this.cipherDetails);
            }
            catch (IOException e) {
                String msg = String.format("Unable to load secret key from file: %s", keyPath);
                throw new UncheckedIOException(msg, e);
            }
        } else if (config.getEncryptionPrivateKeyBytes() != null) {
            this.secretKey = SecretKeyUtils.loadKey(config.getEncryptionPrivateKeyBytes(), this.cipherDetails);
        } else {
            throw new MantaClientEncryptionException("Either private encryption key path or bytes must be specified");
        }
    }

    @Override
    public HttpResponse httpHead(String path) throws IOException {
        HttpResponse response = super.httpHead(path);
        this.attachMetadata(response);
        return response;
    }

    @Override
    public HttpResponse httpGet(String path) throws IOException {
        HttpResponse response = super.httpGet(path);
        this.attachMetadata(response);
        return response;
    }

    @Override
    public MantaObjectResponse httpPut(String path, MantaHttpHeaders headers, HttpEntity originalEntity, MantaMetadata originalMetadata) throws IOException {
        MantaHttpHeaders httpHeaders = headers == null ? new MantaHttpHeaders() : headers;
        EncryptingEntity encryptingEntity = new EncryptingEntity(this.secretKey, this.cipherDetails, originalEntity);
        MantaMetadata metadata = originalMetadata != null ? originalMetadata : new MantaMetadata();
        String contentType = this.findOriginalContentType(originalEntity, httpHeaders);
        if (contentType != null && !metadata.containsKey("e-content-type")) {
            metadata.put("e-content-type", contentType);
        }
        this.attachEncryptionCipherHeaders(metadata);
        this.attachEncryptedEntityHeaders(metadata, encryptingEntity.getCipher());
        this.attachEncryptionPlaintextLengthHeader(metadata, encryptingEntity);
        this.attachEncryptedMetadata(metadata);
        MantaObjectResponse response = super.httpPut(path, httpHeaders, encryptingEntity, metadata);
        response.setContentType(contentType);
        if (originalEntity.getContentLength() < 0L && this.cipherDetails.plaintextSizeCalculationIsAnEstimate()) {
            this.appendPlaintextContentLength(path, encryptingEntity, metadata, response);
        }
        return response;
    }

    @Override
    public MantaObjectInputStream httpRequestAsInputStream(HttpUriRequest request, MantaHttpHeaders requestHeaders) throws IOException {
        Long plaintextEnd;
        Long plaintextStart;
        Long plaintextRangeLength;
        Long initialSkipBytes;
        boolean hasRangeRequest;
        boolean bl = hasRangeRequest = requestHeaders != null && requestHeaders.getRange() != null;
        if (hasRangeRequest && this.encryptionAuthenticationMode.equals((Object)EncryptionAuthenticationMode.Mandatory)) {
            String msg = "HTTP range requests (random reads) aren't supported when using client-side encryption in mandatory authentication mode.";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)request, null);
            throw e;
        }
        if (hasRangeRequest) {
            PlaintextByteRangePosition rangeProperties = this.calculateSkipBytesAndPlaintextLength(request, requestHeaders);
            initialSkipBytes = rangeProperties.getInitialPlaintextSkipBytes();
            plaintextRangeLength = rangeProperties.getPlaintextRangeLength();
            plaintextStart = rangeProperties.getPlaintextStart();
            plaintextEnd = rangeProperties.getPlaintextEnd();
        } else {
            initialSkipBytes = null;
            plaintextRangeLength = null;
            plaintextStart = null;
            plaintextEnd = null;
        }
        MantaObjectInputStream rawStream = super.httpRequestAsInputStream(request, requestHeaders);
        HttpResponse response = (HttpResponse)rawStream.getHttpResponse();
        String cipherId = rawStream.getHeaderAsString("m-encrypt-cipher");
        if (cipherId == null) {
            if (this.permitUnencryptedDownloads) {
                return rawStream;
            }
            String msg = "Unable to download a unencrypted file when client-side encryption is enabled unless the permit unencrypted downloads configuration setting is enabled";
            MantaClientEncryptionException mcee = new MantaClientEncryptionException(msg);
            HttpHelper.annotateContextedException((ExceptionContext)mcee, (HttpRequest)request, response);
            try {
                rawStream.close();
            }
            catch (IOException ioe) {
                MantaIOException mioe = new MantaIOException(ioe);
                HttpHelper.annotateContextedException(mioe, (HttpRequest)request, response);
                LOGGER.debug("Error closing underlying stream", (Throwable)mioe);
            }
            throw mcee;
        }
        this.enforceCipherAndMode(cipherId, (HttpRequest)request, response);
        String encryptionType = rawStream.getHeaderAsString("m-encrypt-type");
        String metadataIvBase64 = rawStream.getHeaderAsString("m-encrypt-metadata-iv");
        String metadataCiphertextBase64 = rawStream.getHeaderAsString("m-encrypt-metadata");
        String hmacId = rawStream.getHeaderAsString("m-encrypt-hmac-type");
        String metadataHmacBase64 = rawStream.getHeaderAsString("m-encrypt-metadata-hmac");
        if (metadataCiphertextBase64 != null) {
            Map<String, String> encryptedMetadata = this.buildEncryptedMetadata(encryptionType, metadataIvBase64, metadataCiphertextBase64, hmacId, metadataHmacBase64, (HttpRequest)request, response);
            rawStream.getMetadata().putAll((Map<? extends String, ? extends String>)encryptedMetadata);
        }
        if (hasRangeRequest) {
            boolean unboundedEnd = plaintextEnd >= this.cipherDetails.getMaximumPlaintextSizeInBytes() || plaintextEnd < 0L;
            String originalPlaintextLengthS = rawStream.getHeaderAsString("m-encrypt-plaintext-content-length");
            if (originalPlaintextLengthS != null && originalPlaintextLengthS.length() > 0) {
                Long originalPlaintextLength = Long.parseLong(originalPlaintextLengthS);
                if (plaintextRangeLength == 0L || plaintextRangeLength >= originalPlaintextLength) {
                    plaintextRangeLength = originalPlaintextLength - plaintextStart;
                }
                if (plaintextStart > 0L && plaintextEnd >= originalPlaintextLength) {
                    plaintextRangeLength = originalPlaintextLength - plaintextStart;
                    unboundedEnd = false;
                } else {
                    unboundedEnd = plaintextEnd < 0L;
                }
            }
            return new MantaEncryptedObjectInputStream(rawStream, this.cipherDetails, this.secretKey, false, initialSkipBytes, plaintextRangeLength, unboundedEnd);
        }
        boolean authenticateCiphertext = !this.encryptionAuthenticationMode.equals((Object)EncryptionAuthenticationMode.VerificationDisabled);
        return new MantaEncryptedObjectInputStream(rawStream, this.cipherDetails, this.secretKey, authenticateCiphertext);
    }

    private PlaintextByteRangePosition calculateSkipBytesAndPlaintextLength(HttpUriRequest request, MantaHttpHeaders requestHeaders) throws IOException {
        long binaryEndPositionInclusive;
        long binaryStartPositionInclusive;
        Long initialSkipBytes;
        boolean negativeEndRequest;
        Long plaintextRangeLength = 0L;
        long[] plaintextRanges = EncryptionHttpHelper.byteRangeAsNullSafe(requestHeaders.getByteRange(), this.cipherDetails);
        long plaintextStart = plaintextRanges[0];
        long plaintextEnd = plaintextRanges[1];
        boolean bl = negativeEndRequest = plaintextEnd < 0L;
        if (plaintextStart == 0L && negativeEndRequest) {
            String path = request.getURI().getPath();
            HttpHead head = this.getRequestFactory().head(path);
            MantaHttpRequestFactory.addHeaders((HttpMessage)head, request.getAllHeaders());
            head.removeHeaders("Range");
            CloseableHttpResponse headResponse = super.executeAndCloseRequest((HttpUriRequest)head, "HEAD   {} response [{}] {} ", new Object[0]);
            MantaHttpHeaders headers = new MantaHttpHeaders(headResponse.getAllHeaders());
            MantaObjectResponse objectResponse = new MantaObjectResponse(path, headers);
            request.setHeader("If-Match", objectResponse.getEtag());
            request.setHeader("If-Unmodified-Since", objectResponse.getHeaderAsString("Last-Modified"));
            Long ciphertextSize = objectResponse.getContentLength();
            Validate.notNull((Object)ciphertextSize, (String)"Manta should always return a content-size", (Object[])new Object[0]);
            long fullPlaintextSize = HttpHelper.attemptToFindPlaintextSize(objectResponse, ciphertextSize, this.cipherDetails);
            initialSkipBytes = plaintextEnd + fullPlaintextSize;
            ByteRangeConversion computedRanges = this.cipherDetails.translateByteRange(initialSkipBytes, fullPlaintextSize - 1L);
            binaryStartPositionInclusive = computedRanges.getCiphertextStartPositionInclusive();
            binaryEndPositionInclusive = ciphertextSize;
        } else {
            long scaledPlaintextEnd = plaintextEnd;
            if (plaintextEnd == this.cipherDetails.getMaximumPlaintextSizeInBytes()) {
                --scaledPlaintextEnd;
            }
            ByteRangeConversion computedRanges = this.cipherDetails.translateByteRange(plaintextStart, scaledPlaintextEnd);
            binaryStartPositionInclusive = computedRanges.getCiphertextStartPositionInclusive();
            initialSkipBytes = computedRanges.getPlaintextBytesToSkipInitially() + computedRanges.getCiphertextStartPositionInclusive();
            binaryEndPositionInclusive = computedRanges.getCiphertextEndPositionInclusive() > 0L ? computedRanges.getCiphertextEndPositionInclusive() : 0L;
            plaintextRangeLength = scaledPlaintextEnd - plaintextStart + 1L;
        }
        if (binaryEndPositionInclusive == 0L) {
            requestHeaders.setRange(String.format("bytes=%d-", binaryStartPositionInclusive));
        } else {
            requestHeaders.setRange(String.format("bytes=%d-%d", binaryStartPositionInclusive, binaryEndPositionInclusive));
        }
        if (plaintextEnd >= this.cipherDetails.getMaximumPlaintextSizeInBytes()) {
            plaintextRangeLength = 0L;
        }
        return new PlaintextByteRangePosition().setInitialPlaintextSkipBytes(initialSkipBytes).setPlaintextRangeLength(plaintextRangeLength).setPlaintextStart(plaintextStart).setPlaintextEnd(plaintextEnd);
    }

    @Override
    public MantaObjectResponse httpPutMetadata(String path, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        HttpResponse response = this.httpHead(path);
        boolean isEncryptedObject = response.getFirstHeader("m-encrypt-cipher") != null;
        Header contentType = response.getFirstHeader("Content-Type");
        if (contentType == null) {
            MantaIOException e = new MantaIOException("Content-Type value expected from Manta unavailable");
            HttpHelper.annotateContextedException(e, null, response);
            throw e;
        }
        boolean isDirectory = contentType.getValue().equals("application/x-json-stream; type=directory");
        if (!isEncryptedObject || isDirectory) {
            return super.httpPutMetadata(path, headers, metadata);
        }
        if (response.getFirstHeader("m-encrypt-cipher") == null) {
            return super.httpPutMetadata(path, headers, metadata);
        }
        Header etag = response.getFirstHeader("ETag");
        if (etag == null) {
            MantaIOException e = new MantaIOException("ETag value expected from Manta unavailable");
            HttpHelper.annotateContextedException(e, null, response);
            throw e;
        }
        Header lastModified = response.getFirstHeader("Last-Modified");
        if (lastModified == null) {
            MantaIOException e = new MantaIOException("Last-Modified value expected from Manta unavailable");
            HttpHelper.annotateContextedException(e, null, response);
            throw e;
        }
        Header actualContentType = response.getFirstHeader("e-content-type");
        if (actualContentType != null) {
            metadata.putIfAbsent("e-content-type", actualContentType.getValue());
        }
        for (String h : MantaHttpHeaders.ENCRYPTED_ENTITY_HEADERS) {
            Header header = response.getFirstHeader(h);
            if (header == null) continue;
            metadata.putIfAbsent(h, header.getValue());
        }
        headers.put("If-Match", (Object)etag.getValue());
        headers.put("If-Unmodified-Since", (Object)lastModified.getValue());
        this.attachEncryptionCipherHeaders(metadata);
        this.attachEncryptedMetadata(metadata);
        return super.httpPutMetadata(path, headers, metadata);
    }

    private void attachMetadata(HttpResponse response) {
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        String contentType = contentTypeHeader == null ? null : contentTypeHeader.getValue();
        if (contentType != null && contentType.equals("application/x-json-stream; type=directory")) {
            return;
        }
        Map<String, String> encryptedMetadata = this.extractEncryptionHeadersFromResponse(response);
        if (encryptedMetadata == null) {
            return;
        }
        for (Map.Entry<String, String> entry : encryptedMetadata.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        String encryptedContentType = encryptedMetadata.get("e-content-type");
        if (encryptedContentType != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Encrypted content-type [{}] overwriting returned content-type [{}]", (Object)encryptedContentType, (Object)response.getFirstHeader("Content-Type"));
            }
            response.setHeader("Content-Type", encryptedContentType);
        }
    }

    private Map<String, String> extractEncryptionHeadersFromResponse(HttpResponse response) {
        Header[] headers;
        String cipherId = null;
        String encryptionType = null;
        String metadataIvBase64 = null;
        String metadataCiphertextBase64 = null;
        String hmacId = null;
        String metadataHmacBase64 = null;
        block16: for (Header h : headers = response.getAllHeaders()) {
            if (!h.getName().startsWith("m-")) continue;
            switch (h.getName()) {
                case "m-encrypt-type": {
                    encryptionType = h.getValue();
                    continue block16;
                }
                case "m-encrypt-metadata-iv": {
                    metadataIvBase64 = h.getValue();
                    continue block16;
                }
                case "m-encrypt-cipher": {
                    cipherId = h.getValue();
                    continue block16;
                }
                case "m-encrypt-metadata": {
                    metadataCiphertextBase64 = h.getValue();
                    continue block16;
                }
                case "m-encrypt-hmac-type": {
                    hmacId = h.getValue();
                    continue block16;
                }
                case "m-encrypt-metadata-hmac": {
                    metadataHmacBase64 = h.getValue();
                    continue block16;
                }
            }
        }
        if (metadataCiphertextBase64 == null) {
            return null;
        }
        if (cipherId == null) {
            return null;
        }
        this.enforceCipherAndMode(cipherId, null, response);
        return this.buildEncryptedMetadata(encryptionType, metadataIvBase64, metadataCiphertextBase64, hmacId, metadataHmacBase64, null, response);
    }

    private Map<String, String> buildEncryptedMetadata(String encryptionType, String metadataIvBase64, String metadataCiphertextBase64, String hmacId, String metadataHmacBase64, HttpRequest request, HttpResponse response) {
        try {
            EncryptionType.validateEncryptionTypeIsSupported(encryptionType);
        }
        catch (MantaClientEncryptionException e) {
            HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
            throw e;
        }
        byte[] metadataIv = Base64.getDecoder().decode(metadataIvBase64);
        Cipher metadataCipher = this.buildMetadataDecryptCipher(metadataIv);
        if (metadataCiphertextBase64 == null) {
            String msg = "No encrypted metadata stored on object";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
            throw e;
        }
        byte[] metadataCipherText = Base64.getDecoder().decode(metadataCiphertextBase64);
        if (!this.cipherDetails.isAEADCipher()) {
            if (hmacId == null) {
                String msg = "No HMAC algorithm specified for metadata ciphertext authentication";
                MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
                HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
                throw e;
            }
            Supplier hmacSupplier = (Supplier)SupportedHmacsLookupMap.INSTANCE.get(hmacId);
            if (hmacSupplier == null) {
                String msg = String.format("Unsupported HMAC specified: %s", hmacId);
                MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
                HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
                throw e;
            }
            HMac hmac = (HMac)hmacSupplier.get();
            EncryptionHttpHelper.initHmac(this.secretKey, hmac);
            hmac.update(metadataCipherText, 0, metadataCipherText.length);
            byte[] actualHmac = new byte[hmac.getMacSize()];
            hmac.doFinal(actualHmac, 0);
            if (metadataHmacBase64 == null) {
                String msg = "No metadata HMAC is available to authenticate metadata ciphertext";
                MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
                HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
                throw e;
            }
            byte[] expectedHmac = Base64.getDecoder().decode(metadataHmacBase64);
            if (!Arrays.equals(expectedHmac, actualHmac)) {
                String msg = "The expected HMAC value for metadata ciphertext didn't equal the actual value";
                MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
                HttpHelper.annotateContextedException((ExceptionContext)e, request, null);
                e.setContextValue("expected", Hex.encodeHexString((byte[])expectedHmac));
                e.setContextValue("actual", Hex.encodeHexString((byte[])actualHmac));
                throw e;
            }
        }
        byte[] plaintext = this.decryptMetadata(metadataCipherText, metadataCipher);
        return EncryptedMetadataUtils.plaintextMetadataAsMap(plaintext);
    }

    public void attachEncryptionCipherHeaders(MantaMetadata metadata) {
        metadata.put("m-encrypt-key-id", this.encryptionKeyId);
        LOGGER.debug("Secret key id: {}", (Object)this.encryptionKeyId);
        metadata.put("m-encrypt-type", EncryptionType.CLIENT.toString());
        LOGGER.debug("Encryption type: {}", (Object)EncryptionType.CLIENT);
        metadata.put("m-encrypt-cipher", this.cipherDetails.getCipherId());
        LOGGER.debug("Encryption cipher: {}", (Object)this.cipherDetails.getCipherId());
    }

    public void attachEncryptedEntityHeaders(MantaMetadata metadata, Cipher cipher) throws IOException {
        Validate.notNull((Object)metadata, (String)"Metadata object must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)cipher, (String)"Cipher object must not be null", (Object[])new Object[0]);
        byte[] iv = cipher.getIV();
        Validate.notNull((Object)iv, (String)"Cipher IV must not be null", (Object[])new Object[0]);
        String ivBase64 = Base64.getEncoder().encodeToString(iv);
        metadata.put("m-encrypt-iv", ivBase64);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("IV: {}", (Object)Hex.encodeHexString((byte[])cipher.getIV()));
        }
        if (this.cipherDetails.isAEADCipher()) {
            metadata.put("m-encrypt-aead-tag-length", String.valueOf(this.cipherDetails.getAuthenticationTagOrHmacLengthInBytes()));
            LOGGER.debug("AEAD tag length: {}", (Object)this.cipherDetails.getAuthenticationTagOrHmacLengthInBytes());
        } else {
            HMac hmac = this.cipherDetails.getAuthenticationHmac();
            String hmacName = SupportedHmacsLookupMap.hmacNameFromInstance(hmac);
            metadata.put("m-encrypt-hmac-type", hmacName);
            LOGGER.debug("HMAC algorithm: {}", (Object)hmacName);
        }
    }

    public void attachEncryptionPlaintextLengthHeader(MantaMetadata metadata, long length) {
        if (length > -1L) {
            String originalLength = String.valueOf(length);
            metadata.put("m-encrypt-plaintext-content-length", originalLength);
            LOGGER.debug("Plaintext content-length: {}", (Object)originalLength);
        }
    }

    public void attachEncryptionPlaintextLengthHeader(MantaMetadata metadata, EncryptingEntity encryptingEntity) {
        this.attachEncryptionPlaintextLengthHeader(metadata, encryptingEntity.getOriginalLength());
    }

    public void attachEncryptedMetadata(MantaMetadata metadata) throws IOException {
        Cipher metadataCipher = this.buildMetadataEncryptCipher();
        metadata.put("m-encrypt-cipher", this.cipherDetails.getCipherId());
        String metadataIvBase64 = Base64.getEncoder().encodeToString(metadataCipher.getIV());
        metadata.put("m-encrypt-metadata-iv", metadataIvBase64);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encrypted metadata IV: {}", (Object)Hex.encodeHexString((byte[])metadataCipher.getIV()));
        }
        String metadataPlainTextString = EncryptedMetadataUtils.encryptedMetadataAsString(metadata);
        LOGGER.debug("Encrypted metadata plaintext:\n{}", (Object)metadataPlainTextString);
        LOGGER.debug("Encrypted metadata ciphertext: {}", (Object)metadataIvBase64);
        byte[] metadataCipherText = this.encryptMetadata(metadataPlainTextString, metadataCipher);
        String metadataCipherTextBase64 = Base64.getEncoder().encodeToString(metadataCipherText);
        if (metadataCipherTextBase64.length() > 4000) {
            String msg = "Encrypted metadata exceeded the maximum size allowed";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            e.setContextValue("max_size", 4000);
            e.setContextValue("actual_size", metadataCipherTextBase64.length());
            throw e;
        }
        metadata.put("m-encrypt-metadata", metadataCipherTextBase64);
        if (!this.cipherDetails.isAEADCipher()) {
            HMac hmac = this.cipherDetails.getAuthenticationHmac();
            EncryptionHttpHelper.initHmac(this.secretKey, hmac);
            hmac.update(metadataCipherText, 0, metadataCipherText.length);
            byte[] checksum = new byte[hmac.getMacSize()];
            hmac.doFinal(checksum, 0);
            String checksumBase64 = Base64.getEncoder().encodeToString(checksum);
            metadata.put("m-encrypt-metadata-hmac", checksumBase64);
            LOGGER.debug("Encrypted metadata HMAC: {}", (Object)checksumBase64);
        } else {
            metadata.put("m-encrypt-metadata-aead-tag-length", String.valueOf(this.cipherDetails.getAuthenticationTagOrHmacLengthInBytes()));
        }
    }

    public SupportedCipherDetails getCipherDetails() {
        return this.cipherDetails;
    }

    private String findOriginalContentType(HttpEntity originalEntity, MantaHttpHeaders httpHeaders) {
        String entityContentType = originalEntity.getContentType() == null ? null : originalEntity.getContentType().getValue();
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{httpHeaders.getContentType(), entityContentType});
    }

    private void appendPlaintextContentLength(String path, EncryptingEntity encryptingEntity, MantaMetadata metadata, MantaObjectResponse response) throws IOException {
        List<BasicNameValuePair> pairs = Collections.singletonList(new BasicNameValuePair("metadata", "true"));
        HttpPut put = this.getRequestFactory().put(path, pairs);
        metadata.put("m-encrypt-plaintext-content-length", String.valueOf(encryptingEntity.getOriginalLength()));
        MantaHttpHeaders updateHeaders = new MantaHttpHeaders();
        updateHeaders.putAll(metadata);
        updateHeaders.put("If-Match", (Object)response.getEtag());
        updateHeaders.put("If-Unmodified-Since", (Object)response.getLastModifiedTime());
        put.setHeaders(updateHeaders.asApacheHttpHeaders());
        put.setEntity((HttpEntity)NoContentEntity.INSTANCE);
        CloseableHttpClient client = this.getConnectionContext().getHttpClient();
        CloseableHttpResponse originalContentLengthUpdateResponse = client.execute((HttpUriRequest)put);
        IOUtils.closeQuietly((Closeable)originalContentLengthUpdateResponse);
        StatusLine statusLine = originalContentLengthUpdateResponse.getStatusLine();
        int code = statusLine.getStatusCode();
        if (code != 204 && code != 412) {
            MantaIOException e = new MantaIOException("Unable to update metadata with original plaintext content length");
            HttpHelper.annotateContextedException(e, (HttpRequest)put, (HttpResponse)originalContentLengthUpdateResponse);
            throw e;
        }
    }

    private byte[] encryptMetadata(String metadataPlaintext, Cipher cipher) {
        byte[] rawBytes = metadataPlaintext.getBytes(StandardCharsets.US_ASCII);
        try {
            return cipher.doFinal(rawBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            MantaClientEncryptionException mcee = new MantaClientEncryptionException("There was a problem encrypting the object's metadata", e);
            String details = String.format("key=%s, algorithm=%s", this.secretKey.getAlgorithm(), this.secretKey.getFormat());
            mcee.setContextValue("key_details", details);
            throw mcee;
        }
    }

    private byte[] decryptMetadata(byte[] metadataCiphertext, Cipher cipher) {
        try {
            return cipher.doFinal(metadataCiphertext);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            MantaClientEncryptionException mcee = new MantaClientEncryptionException("There was a problem decrypting the object's metadata", e);
            String details = String.format("key=%s, algorithm=%s", this.secretKey.getAlgorithm(), this.secretKey.getFormat());
            mcee.setContextValue("key_details", details);
            throw mcee;
        }
    }

    private Cipher buildMetadataEncryptCipher() {
        byte[] metadataIv = this.cipherDetails.generateIv();
        Cipher metadataCipher = this.cipherDetails.getCipher();
        try {
            AlgorithmParameterSpec spec = this.cipherDetails.getEncryptionParameterSpec(metadataIv);
            metadataCipher.init(1, (Key)this.secretKey, spec);
        }
        catch (InvalidKeyException e) {
            MantaClientEncryptionException mcee = new MantaClientEncryptionException("There was a problem loading private key", e);
            String details = String.format("key=%s, algorithm=%s", this.secretKey.getAlgorithm(), this.secretKey.getFormat());
            mcee.setContextValue("key_details", details);
            throw mcee;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MantaClientEncryptionException("There was a problem with the passed algorithm parameters", e);
        }
        return metadataCipher;
    }

    private Cipher buildMetadataDecryptCipher(byte[] metadataIv) {
        Cipher metadataCipher = this.cipherDetails.getCipher();
        try {
            AlgorithmParameterSpec spec = this.cipherDetails.getEncryptionParameterSpec(metadataIv);
            metadataCipher.init(2, (Key)this.secretKey, spec);
        }
        catch (InvalidKeyException e) {
            MantaClientEncryptionException mcee = new MantaClientEncryptionException("There was a problem loading private key", e);
            String details = String.format("key=%s, algorithm=%s", this.secretKey.getAlgorithm(), this.secretKey.getFormat());
            mcee.setContextValue("key_details", details);
            throw mcee;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MantaClientEncryptionException("There was a problem with the passed algorithm parameters", e);
        }
        return metadataCipher;
    }

    private void enforceCipherAndMode(String cipherId, HttpRequest request, HttpResponse response) {
        if (!cipherId.equals(this.cipherDetails.getCipherId())) {
            String msg = "Cipher used to encrypt object is not the same as the cipher configured.";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            HttpHelper.annotateContextedException((ExceptionContext)e, request, response);
            e.setContextValue("objectCipherId", cipherId);
            e.setContextValue("configCipherId", this.cipherDetails.getCipherId());
            throw e;
        }
    }

    static long[] byteRangeAsNullSafe(Long[] ranges, SupportedCipherDetails cipherDetails) {
        long plaintextMax = cipherDetails.getMaximumPlaintextSizeInBytes();
        long startPos = ranges[0] == null ? 0L : ranges[0];
        long endPos = ranges[1] == null ? plaintextMax : ranges[1];
        return new long[]{startPos, endPos};
    }

    private static void initHmac(SecretKey secretKey, HMac hmac) {
        hmac.init((CipherParameters)new KeyParameter(secretKey.getEncoded()));
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

