/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.SharepointSession;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.GroupsIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.resources.GroupItem;

public class SharepointGroupListService
implements ListService {
    private static final Logger log = Logger.getLogger(SharepointGroupListService.class);
    private final SharepointSession session;

    public SharepointGroupListService(SharepointSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        GroupsIterator groupsIterator = new GroupsIterator((OneDriveAPI)this.session.getClient());
        while (groupsIterator.hasNext()) {
            GroupItem.Metadata metadata;
            try {
                metadata = groupsIterator.next();
            }
            catch (OneDriveRuntimeException e) {
                log.warn((Object)e.getMessage());
                continue;
            }
            PathAttributes attributes = new PathAttributes();
            attributes.setVersionId(metadata.getId());
            children.add((Referenceable)new Path(directory, metadata.getDisplayName(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
            listener.chunk(directory, children);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

