/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import dagger.Module;
import dagger.Provides;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.cryptomator.cryptolib.api.CryptoLibVersion;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.SecureRandomModule;
import org.cryptomator.cryptolib.v1.CryptorProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module(includes={SecureRandomModule.class})
public class Version1CryptorModule {
    private static final Logger LOG = LoggerFactory.getLogger(Version1CryptorModule.class);

    @Provides
    @CryptoLibVersion(value=CryptoLibVersion.Version.ONE)
    public CryptorProvider provideCryptorProvider(@SecureRandomModule.FastSecureRandom SecureRandom secureRandom) {
        this.assertRequiredKeyLengthIsAllowed();
        return new CryptorProviderImpl(secureRandom);
    }

    private void assertRequiredKeyLengthIsAllowed() {
        if (!this.isRequiredKeyLengthAllowed()) {
            LOG.error("Required key length not supported. See https://github.com/cryptomator/cryptolib/wiki/Restricted-Key-Size.");
            throw new IllegalStateException("Required key length not supported.");
        }
    }

    boolean isRequiredKeyLengthAllowed() {
        try {
            int requiredKeyLengthBits = 256;
            int allowedKeyLengthBits = Cipher.getMaxAllowedKeyLength("AES");
            return allowedKeyLengthBits >= requiredKeyLengthBits;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Hard-coded algorithm \"AES\" not supported.", e);
        }
    }
}

