/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.TableDelegate;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Comparator;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AbstractTableDelegate<E, Column>
extends ProxyController
implements TableDelegate<E, Column> {
    private NSTableColumn selectedColumn;
    private Boolean sortAscending;

    public AbstractTableDelegate(NSTableColumn selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public void setSelectedColumn(NSTableColumn selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public String selectedColumnIdentifier() {
        return this.selectedColumn.identifier();
    }

    public boolean isColumnRowEditable(NSTableColumn column, NSInteger row) {
        return false;
    }

    public boolean tableView_shouldSelectRow(NSTableView view, NSInteger row) {
        return true;
    }

    public boolean outlineView_shouldSelectItem(NSOutlineView view, NSObject item) {
        return true;
    }

    public boolean tableView_shouldEditTableColumn_row(NSTableView view, NSTableColumn c, NSInteger row) {
        return this.isColumnRowEditable(c, row);
    }

    public boolean outlineView_shouldEditTableColumn_item(NSOutlineView view, NSTableColumn c, NSObject item) {
        return this.isColumnRowEditable(c, view.rowForItem(item));
    }

    public boolean selectionShouldChange() {
        return true;
    }

    public boolean selectionShouldChangeInTableView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public boolean selectionShouldChangeInOutlineView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public abstract void tableColumnClicked(NSTableView var1, NSTableColumn var2);

    public void tableViewColumnDidResize(NSNotification notification) {
        NSTableColumn column = (NSTableColumn)Rococoa.cast((ObjCObject)notification.userInfo().objectForKey("NSTableColumn"), NSTableColumn.class);
        this.columnDidResize(column.identifier(), column.width().floatValue());
    }

    public void outlineViewColumnDidResize(NSNotification notification) {
        NSTableColumn column = (NSTableColumn)Rococoa.cast((ObjCObject)notification.userInfo().objectForKey("NSTableColumn"), NSTableColumn.class);
        this.columnDidResize(column.identifier(), column.width().floatValue());
    }

    public void columnDidResize(String columnIdentifier, float width) {
    }

    public void outlineView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public void tableView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public abstract void tableRowDoubleClicked(ID var1);

    public void tableViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void tableViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public void outlineViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void outlineViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public abstract void selectionDidChange(NSNotification var1);

    public void selectionIsChanging(NSNotification notification) {
    }

    @Override
    public Comparator<E> getSortingComparator() {
        return new NullComparator();
    }

    public void setSortedAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        PreferencesFactory.get().setProperty("browser.sort.ascending", this.sortAscending.booleanValue());
    }

    @Override
    public boolean isSortedAscending() {
        if (null == this.sortAscending) {
            return PreferencesFactory.get().getBoolean("browser.sort.ascending");
        }
        return this.sortAscending;
    }

    public boolean tableView_shouldTypeSelectForEvent_withCurrentSearchString(NSTableView view, NSEvent event, String searchString) {
        return this.isTypeSelectSupported();
    }

    public boolean outlineView_shouldTypeSelectForEvent_withCurrentSearchString(NSOutlineView view, NSEvent event, String searchString) {
        return this.isTypeSelectSupported();
    }

    protected abstract boolean isTypeSelectSupported();
}

