/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;
import org.irods.jargon.core.protovalues.EncryptionAlgorithmEnum;
import org.irods.jargon.core.utils.PropertyUtils;

public class DefaultPropertiesJargonConfig
implements JargonProperties {
    private final Properties jargonProperties;

    @Override
    public int getMaxFilesAndDirsQueryMax() {
        return this.verifyPropExistsAndGetAsInt("max.files.and.dirs.query.max");
    }

    public DefaultPropertiesJargonConfig() throws JargonException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream("jargon.properties");
        this.jargonProperties = new Properties();
        try {
            this.jargonProperties.load(in);
        }
        catch (IOException ioe) {
            throw new JargonException("error loading jargon.properties", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isUseParallelTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.use.parallel");
        return Boolean.valueOf(propVal);
    }

    @Override
    public int getMaxParallelThreads() {
        return this.verifyPropExistsAndGetAsInt("transfer.max.parallel.threads");
    }

    @Override
    public boolean isUseTransferThreadsPool() {
        return this.verifyPropExistsAndGetAsBoolean("transfer.use.pool");
    }

    @Override
    public int getTransferThreadPoolTimeoutMillis() {
        return this.verifyPropExistsAndGetAsInt("transfer.executor.pool.timeout");
    }

    private String verifyPropExistsAndGetAsString(String propKey) {
        return PropertyUtils.verifyPropExistsAndGetAsString(this.jargonProperties, propKey);
    }

    private int verifyPropExistsAndGetAsInt(String propKey) {
        return PropertyUtils.verifyPropExistsAndGetAsInt(this.jargonProperties, propKey);
    }

    private boolean verifyPropExistsAndGetAsBoolean(String propKey) {
        return PropertyUtils.verifyPropExistsAndGetAsBoolean(this.jargonProperties, propKey);
    }

    private long verifyPropExistsAndGetAsLong(String propKey) {
        return PropertyUtils.verifyPropExistsAndGetAsLong(this.jargonProperties, propKey);
    }

    @Override
    public boolean isAllowPutGetResourceRedirects() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.allow.redirects");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isComputeChecksumAfterTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.compute.checksum");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isComputeAndVerifyChecksumAfterTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.computeandvalidate.checksum");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isIntraFileStatusCallbacks() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.intra.file.callbacks");
        return Boolean.valueOf(propVal);
    }

    @Override
    public int getIRODSSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("socket.timeout");
    }

    @Override
    public int getIRODSParallelTransferSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("parallel.socket.timeout");
    }

    @Override
    public int getTransferThreadPoolMaxSimultaneousTransfers() {
        return this.verifyPropExistsAndGetAsInt("transfer.executor.pool.max.simultaneous.transfers");
    }

    @Override
    public int getInternalInputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.input.stream.buffer.size");
    }

    @Override
    public int getInternalOutputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.output.stream.buffer.size");
    }

    @Override
    public int getInternalCacheBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.cache.buffer.size");
    }

    @Override
    public int getSendInputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.send.input.stream.buffer.size");
    }

    @Override
    public int getInputToOutputCopyBufferByteSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.input.to.output.copy.byte.buffer.size");
    }

    @Override
    public int getLocalFileOutputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.local.output.stream.buffer.size");
    }

    @Override
    public int getPutBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.put.buffer.size");
    }

    @Override
    public int getGetBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.get.buffer.size");
    }

    @Override
    public String getEncoding() {
        return this.verifyPropExistsAndGetAsString("encoding");
    }

    @Override
    public int getLocalFileInputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.local.input.stream.buffer.size");
    }

    @Override
    public boolean isReconnect() {
        return this.verifyPropExistsAndGetAsBoolean("jargon.reconnect");
    }

    @Override
    public boolean isInstrument() {
        return this.verifyPropExistsAndGetAsBoolean("jargon.instrument");
    }

    @Override
    public boolean isDefaultToPublicIfNothingUnderRootWhenListing() {
        return this.verifyPropExistsAndGetAsBoolean("default.to.public.if.nothing.under.root.when.listing");
    }

    @Override
    public long getReconnectTimeInMillis() {
        return this.verifyPropExistsAndGetAsLong("jargon.reconnect.time.in.millis");
    }

    @Override
    public boolean isUsingDiscoveredServerPropertiesCache() {
        return this.verifyPropExistsAndGetAsBoolean("use.discovered.server.properties.cache");
    }

    @Override
    public boolean isUsingSpecificQueryForCollectionListingsWithPermissions() {
        return this.verifyPropExistsAndGetAsBoolean("use.specific.query.for.collection.listings");
    }

    @Override
    public boolean isUsingSpecQueryForDataObjPermissionsForUserInGroup() {
        return this.verifyPropExistsAndGetAsBoolean("use.specquery.for.dataobj.permissions.for.user.in.group");
    }

    @Override
    public int getPAMTimeToLive() {
        return this.verifyPropExistsAndGetAsInt("pam.time.to.live.in.seconds");
    }

    @Override
    public boolean isForcePamFlush() {
        return this.verifyPropExistsAndGetAsBoolean("force.pam.flush");
    }

    @Override
    public String getConnectionFactory() {
        String propVal = (String)this.jargonProperties.get("connection.factory");
        if (propVal == null) {
            propVal = "tcp";
        }
        return propVal;
    }

    @Override
    public ChecksumEncodingEnum getChecksumEncoding() {
        String propVal = (String)this.jargonProperties.get("transfer.checksum.algorithm");
        if (propVal == null || propVal.isEmpty()) {
            return ChecksumEncodingEnum.DEFAULT;
        }
        return ChecksumEncodingEnum.findTypeByString(propVal);
    }

    @Override
    public boolean isParallelTcpKeepAlive() {
        return this.verifyPropExistsAndGetAsBoolean("parallelTcpKeepAlive");
    }

    @Override
    public int getParallelTcpSendWindowSize() {
        return this.verifyPropExistsAndGetAsInt("parallelTcpSendWindowSize");
    }

    @Override
    public int getParallelTcpReceiveWindowSize() {
        return this.verifyPropExistsAndGetAsInt("parallelTcpReceiveWindowSize");
    }

    @Override
    public int getParallelTcpPerformancePrefsConnectionTime() {
        return this.verifyPropExistsAndGetAsInt("parallelTcpPrefs.connectionTime");
    }

    @Override
    public int getParallelTcpPerformancePrefsLatency() {
        return this.verifyPropExistsAndGetAsInt("parallelTcpPrefs.latency");
    }

    @Override
    public int getParallelTcpPerformancePrefsBandwidth() {
        return this.verifyPropExistsAndGetAsInt("parallelTcpPrefs.bandwidth");
    }

    @Override
    public boolean isPrimaryTcpKeepAlive() {
        return this.verifyPropExistsAndGetAsBoolean("primaryTcpKeepAlive");
    }

    @Override
    public int getPrimaryTcpSendWindowSize() {
        return this.verifyPropExistsAndGetAsInt("primaryTcpSendWindowSize");
    }

    @Override
    public int getPrimaryTcpReceiveWindowSize() {
        return this.verifyPropExistsAndGetAsInt("primaryTcpReceiveWindowSize");
    }

    @Override
    public int getPrimaryTcpPerformancePrefsConnectionTime() {
        return this.verifyPropExistsAndGetAsInt("primaryTcpPrefs.connectionTime");
    }

    @Override
    public int getPrimaryTcpPerformancePrefsLatency() {
        return this.verifyPropExistsAndGetAsInt("primaryTcpPrefs.latency");
    }

    @Override
    public int getPrimaryTcpPerformancePrefsBandwidth() {
        return this.verifyPropExistsAndGetAsInt("primaryTcpPrefs.bandwidth");
    }

    @Override
    public int getSocketRenewalIntervalInSeconds() {
        return this.verifyPropExistsAndGetAsInt("socket.renewal.interval.in.seconds");
    }

    @Override
    public boolean isLongTransferRestart() {
        return this.verifyPropExistsAndGetAsBoolean("transfer.long.file.restart");
    }

    @Override
    public int getParallelCopyBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.parallel.copy.buffer.size");
    }

    @Override
    public int getIntraFileStatusCallbacksNumberCallsInterval() {
        return this.verifyPropExistsAndGetAsInt("transfer.intra.file.callback.after.n.calls");
    }

    @Override
    public long getIntraFileStatusCallbacksTotalBytesInterval() {
        return this.verifyPropExistsAndGetAsLong("transfer.intra.file.callback.after.n.bytes");
    }

    @Override
    public ClientServerNegotiationPolicy.SslNegotiationPolicy getNegotiationPolicy() {
        String policyString = this.verifyPropExistsAndGetAsString("ssl.negotiation.policy");
        if (policyString.isEmpty()) {
            return ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION;
        }
        if (policyString.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_DONT_CARE.name())) {
            return ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_DONT_CARE;
        }
        if (policyString.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REFUSE.name())) {
            return ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REFUSE;
        }
        if (policyString.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REQUIRE.name())) {
            return ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REQUIRE;
        }
        if (policyString.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION.name())) {
            return ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION;
        }
        throw new UnsupportedOperationException("unknown negotiation policy");
    }

    @Override
    public EncryptionAlgorithmEnum getEncryptionAlgorithmEnum() {
        String enumString = this.verifyPropExistsAndGetAsString("ssl.parallel.encryption.algo");
        if (enumString.isEmpty()) {
            return EncryptionAlgorithmEnum.AES_256_CBC;
        }
        return EncryptionAlgorithmEnum.findTypeByString(enumString);
    }

    @Override
    public int getEncryptionKeySize() {
        return this.verifyPropExistsAndGetAsInt("ssl.parallel.encryption.key.size");
    }

    @Override
    public int getEncryptionSaltSize() {
        return this.verifyPropExistsAndGetAsInt("ssl.parallel.encryption.salt.size");
    }

    @Override
    public int getEncryptionNumberHashRounds() {
        return this.verifyPropExistsAndGetAsInt("ssl.parallel.encryption.number.hash.rounds");
    }

    @Override
    public boolean isBypassSslCertChecks() {
        return this.verifyPropExistsAndGetAsBoolean("bypass.ssl.cert.checks");
    }
}

