/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.ConnectionDetailsImpl;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.Ds3ClientImpl;
import com.spectralogic.ds3client.models.common.Credentials;
import com.spectralogic.ds3client.networking.NetworkClientImpl;
import com.spectralogic.ds3client.utils.Builder;
import com.spectralogic.ds3client.utils.Guard;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ds3ClientBuilder
implements Builder<Ds3Client> {
    private static final Logger LOG = LoggerFactory.getLogger(Ds3ClientBuilder.class);
    private static final String ENDPOINT = "DS3_ENDPOINT";
    private static final String ACCESS_KEY = "DS3_ACCESS_KEY";
    private static final String SECRET_KEY = "DS3_SECRET_KEY";
    private final String endpoint;
    private final Credentials credentials;
    private boolean https = true;
    private boolean certificateVerification = true;
    private URI proxy = null;
    private int retries = 5;
    private int connectionTimeoutInMillis = 5000;
    private int bufferSizeInBytes = 0x100000;
    private int socketTimeoutInMillis = 3600000;
    private String userAgent;

    private Ds3ClientBuilder(String endpoint, Credentials credentials) throws IllegalArgumentException {
        if (Guard.isStringNullOrEmpty((String)endpoint)) {
            throw new IllegalArgumentException("Endpoint must be non empty");
        }
        if (credentials == null || !credentials.isValid()) {
            throw new IllegalArgumentException("Credentials must be filled out.");
        }
        this.endpoint = endpoint.trim();
        this.credentials = credentials;
    }

    public static Ds3ClientBuilder create(String endpoint, Credentials creds) {
        return new Ds3ClientBuilder(endpoint, creds);
    }

    public static Ds3ClientBuilder fromEnv() throws IllegalArgumentException {
        String endpoint = System.getenv(ENDPOINT);
        if (Guard.isStringNullOrEmpty((String)endpoint)) {
            throw new IllegalArgumentException("Missing DS3_ENDPOINT environment variable");
        }
        String accessKey = System.getenv(ACCESS_KEY);
        if (Guard.isStringNullOrEmpty((String)accessKey)) {
            throw new IllegalArgumentException("Missing DS3_ACCESS_KEY environment variable");
        }
        String secretKey = System.getenv(SECRET_KEY);
        if (Guard.isStringNullOrEmpty((String)secretKey)) {
            throw new IllegalArgumentException("Missing DS3_SECRET_KEY environment variable");
        }
        Ds3ClientBuilder builder = Ds3ClientBuilder.create(endpoint, new Credentials(accessKey, secretKey));
        String httpProxy = System.getenv("http_proxy");
        if (httpProxy != null) {
            builder.withProxy(httpProxy);
        }
        return builder;
    }

    public Ds3ClientBuilder withHttps(boolean secure) {
        this.https = secure;
        return this;
    }

    public Ds3ClientBuilder withBufferSize(int bufferSizeInBytes) {
        this.bufferSizeInBytes = bufferSizeInBytes;
        return this;
    }

    public Ds3ClientBuilder withCertificateVerification(boolean certificateVerification) {
        this.certificateVerification = certificateVerification;
        return this;
    }

    public Ds3ClientBuilder withProxy(String proxy) throws IllegalArgumentException {
        if (proxy == null) {
            LOG.info("Proxy was null");
            return this;
        }
        try {
            URI proxyUri;
            if (!proxy.startsWith("http")) {
                throw new IllegalArgumentException("Invalid proxy format.  The web address must start with either http or https.");
            }
            this.proxy = proxyUri = new URI(proxy);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid proxy format.  Must be a web address.");
        }
        return this;
    }

    public Ds3ClientBuilder withRedirectRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public Ds3ClientBuilder withConnectionTimeout(int timeoutInMillis) {
        this.connectionTimeoutInMillis = timeoutInMillis;
        return this;
    }

    public Ds3ClientBuilder withSocketTimeout(int timeoutInMillis) {
        this.socketTimeoutInMillis = timeoutInMillis;
        return this;
    }

    public Ds3ClientBuilder withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public Ds3Client build() {
        LOG.info("Making connection details for endpoint [{}] using this authorization id [{}]", (Object)this.endpoint, (Object)this.credentials.getClientId());
        ConnectionDetailsImpl.Builder connBuilder = ConnectionDetailsImpl.builder(this.endpoint, this.credentials).withProxy(this.proxy).withHttps(this.https).withCertificateVerification(this.certificateVerification).withRedirectRetries(this.retries).withBufferSize(this.bufferSizeInBytes).withConnectionTimeout(this.connectionTimeoutInMillis).withSocketTimeout(this.socketTimeoutInMillis).withUserAgent(this.userAgent);
        NetworkClientImpl netClient = new NetworkClientImpl(connBuilder.build());
        return new Ds3ClientImpl(netClient);
    }
}

