/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.ProviderException;

final class GHASH {
    private static final int AES_BLOCK_SIZE = 16;
    private final long subkeyH0;
    private final long subkeyH1;
    private long state0;
    private long state1;
    private long stateSave0;
    private long stateSave1;

    private static long getLong(byte[] byArray, int n) {
        long l = 0L;
        int n2 = n + 8;
        for (int i = n; i < n2; ++i) {
            l = (l << 8) + (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    private static void putLong(byte[] byArray, int n, long l) {
        int n2 = n + 8;
        for (int i = n2 - 1; i >= n; --i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
    }

    private void blockMult(long l, long l2) {
        long l3;
        long l4;
        int n;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = this.state0;
        for (n = 0; n < 64; ++n) {
            l4 = l7 >> 63;
            l5 ^= l & l4;
            l6 ^= l2 & l4;
            l4 = l2 << 63 >> 63;
            l3 = l & 1L;
            l >>>= 1;
            l2 = l2 >>> 1 | l3 << 63;
            l ^= 0xE100000000000000L & l4;
            l7 <<= 1;
        }
        l7 = this.state1;
        for (n = 64; n < 127; ++n) {
            l4 = l7 >> 63;
            l5 ^= l & l4;
            l6 ^= l2 & l4;
            l4 = l2 << 63 >> 63;
            l3 = l & 1L;
            l >>>= 1;
            l2 = l2 >>> 1 | l3 << 63;
            l ^= 0xE100000000000000L & l4;
            l7 <<= 1;
        }
        long l8 = l7 >> 63;
        this.state0 = l5 ^= l & l8;
        this.state1 = l6 ^= l2 & l8;
    }

    GHASH(byte[] byArray) throws ProviderException {
        if (byArray == null || byArray.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.subkeyH0 = GHASH.getLong(byArray, 0);
        this.subkeyH1 = GHASH.getLong(byArray, 8);
    }

    void reset() {
        this.state0 = 0L;
        this.state1 = 0L;
    }

    void save() {
        this.stateSave0 = this.state0;
        this.stateSave1 = this.state1;
    }

    void restore() {
        this.state0 = this.stateSave0;
        this.state1 = this.stateSave1;
    }

    private void processBlock(byte[] byArray, int n) {
        if (byArray.length - n < 16) {
            throw new RuntimeException("need complete block");
        }
        this.state0 ^= GHASH.getLong(byArray, n);
        this.state1 ^= GHASH.getLong(byArray, n + 8);
        this.blockMult(this.subkeyH0, this.subkeyH1);
    }

    void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    void update(byte[] byArray, int n, int n2) {
        if (n2 - n > byArray.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (n2 % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        for (int i = n; i < n + n2; i += 16) {
            this.processBlock(byArray, i);
        }
    }

    byte[] digest() {
        byte[] byArray = new byte[16];
        GHASH.putLong(byArray, 0, this.state0);
        GHASH.putLong(byArray, 8, this.state1);
        this.reset();
        return byArray;
    }
}

