/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.exception.NotFoundException;
import ch.iterate.openstack.swift.model.Container;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class ContainerResponseHandler
implements ResponseHandler<List<Container>> {
    private Region region;

    public ContainerResponseHandler(Region region) {
        this.region = region;
    }

    public List<Container> handleResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            StringTokenizer tokenize = new StringTokenizer(EntityUtils.toString((HttpEntity)response.getEntity()), "\n");
            ArrayList<Container> containers = new ArrayList<Container>();
            while (tokenize.hasMoreTokens()) {
                containers.add(new Container(this.region, tokenize.nextToken()));
            }
            return containers;
        }
        if (response.getStatusLine().getStatusCode() == 204) {
            return new ArrayList<Container>();
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new NotFoundException(new Response(response));
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

