/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import java.util.function.Predicate;

public abstract class ListFilteringFeature {
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public ListFilteringFeature(Session<?> session) {
        this.session = session;
    }

    protected Path search(Path file) throws BackgroundException {
        AttributedList<Path> list;
        if (!this.cache.isCached(file.getParent())) {
            list = this.session._getFeature(ListService.class).list(file.getParent(), new DisabledListProgressListener());
            this.cache.put(file.getParent(), list);
        } else {
            list = this.cache.get(file.getParent());
        }
        Path path = list.find(new DefaultPathPredicate(file));
        if (path != null) {
            return path;
        }
        return list.find((Predicate<Path>)(this.session.getCase() == Session.Case.insensitive ? new CaseInsensitivePathPredicate(file) : new SimplePathPredicate(file)));
    }

    public ListFilteringFeature withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

