/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractCache;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.transfer.TransferItem;

public class TransferItemCache
extends AbstractCache<TransferItem> {
    private static final TransferItem NULL_KEY = new TransferItem(null);

    public static TransferItemCache empty() {
        return new TransferItemCache(0){

            @Override
            public AttributedList<TransferItem> put(TransferItem item, AttributedList<TransferItem> children) {
                return AttributedList.emptyList();
            }
        };
    }

    public TransferItemCache(int size) {
        super(size);
    }

    @Override
    public CacheReference key(TransferItem object) {
        return new DefaultPathPredicate(object.remote);
    }

    @Override
    public boolean containsKey(TransferItem key) {
        return super.containsKey(null == key ? NULL_KEY : key);
    }

    @Override
    public AttributedList<TransferItem> get(TransferItem key) {
        return super.get(null == key ? NULL_KEY : key);
    }

    @Override
    public AttributedList<TransferItem> put(TransferItem key, AttributedList<TransferItem> children) {
        return super.put(null == key ? NULL_KEY : key, children);
    }
}

