/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaObjectAttributeAdapter;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;

public class MantaAttributesFinderFeature
implements AttributesFinder {
    private final MantaSession session;

    public MantaAttributesFinderFeature(MantaSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            return new MantaObjectAttributeAdapter(this.session).convert((MantaObject)((MantaClient)this.session.getClient()).head(file.getAbsolute()));
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }
}

