/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.oauth.OAuth2TokenListener;
import ch.cyberduck.core.oauth.OAuthInterruptedException;
import ch.cyberduck.core.threading.CancelCallback;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OAuth2TokenListenerRegistry {
    private static final OAuth2TokenListenerRegistry global = new OAuth2TokenListenerRegistry();
    private final Set<OAuth2TokenListener> listeners = new HashSet<OAuth2TokenListener>();

    public static OAuth2TokenListenerRegistry get() {
        return global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(OAuth2TokenListener listener, CancelCallback cancel) throws ConnectionCanceledException {
        this.listeners.add(listener);
        OAuth2TokenListenerRegistry oAuth2TokenListenerRegistry = global;
        synchronized (oAuth2TokenListenerRegistry) {
            try {
                while (this.listeners.contains(listener)) {
                    cancel.verify();
                    global.wait(500L);
                }
            }
            catch (InterruptedException e) {
                throw new OAuthInterruptedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String token) {
        Iterator<OAuth2TokenListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().callback(token);
            iter.remove();
        }
        OAuth2TokenListenerRegistry oAuth2TokenListenerRegistry = global;
        synchronized (oAuth2TokenListenerRegistry) {
            global.notifyAll();
        }
    }
}

