/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SDSPermissionsFeature
extends DefaultAclFeature {
    private static final Logger log = Logger.getLogger(SDSPermissionsFeature.class);
    public static final Acl.Role MANAGE_ROLE = new Acl.Role("MANAGE_ROLE");
    public static final Acl.Role READ_ROLE = new Acl.Role("READ");
    public static final Acl.Role CREATE_ROLE = new Acl.Role("CREATE");
    public static final Acl.Role CHANGE_ROLE = new Acl.Role("CHANGE");
    public static final Acl.Role DELETE_ROLE = new Acl.Role("DELETE");
    public static final Acl.Role DOWNLOAD_SHARE_ROLE = new Acl.Role("DOWNLOAD_SHARE");
    public static final Acl.Role UPLOAD_SHARE_ROLE = new Acl.Role("UPLOAD_SHARE");
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSPermissionsFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        if (Acl.EMPTY.equals((Object)file.attributes().getAcl())) {
            return new SDSAttributesFinderFeature(this.session, this.nodeid).find(file).getAcl();
        }
        return file.attributes().getAcl();
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        throw new UnsupportedException();
    }

    public List<Acl.User> getAvailableAclUsers() {
        return Collections.singletonList(new Acl.CanonicalUser(String.valueOf(this.session.userAccount().getId())));
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(MANAGE_ROLE, READ_ROLE, CREATE_ROLE, CHANGE_ROLE, DELETE_ROLE, DOWNLOAD_SHARE_ROLE, UPLOAD_SHARE_ROLE);
    }

    public boolean containsRole(Path file, Acl.Role role) {
        try {
            Acl acl = this.getPermission(file);
            if (acl.isEmpty()) {
                log.warn((Object)String.format("Missing ACL on file %s", file));
                return true;
            }
            Long accountId = this.session.userAccount().getId();
            Set roles = (Set)acl.get((Object)new Acl.CanonicalUser(String.valueOf(accountId)));
            if (null == roles) {
                log.warn((Object)String.format("Missing roles for account %d", accountId));
                return false;
            }
            return roles.contains(role);
        }
        catch (BackgroundException e) {
            log.warn((Object)String.format("Unable to retrieve user account information. %s", e.getDetail()));
            return true;
        }
    }
}

