/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundCallable;
import ch.cyberduck.core.threading.BackgroundExecutor;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.log4j.Logger;

public class DefaultBackgroundExecutor
implements BackgroundExecutor {
    private static final Logger log = Logger.getLogger(DefaultBackgroundExecutor.class);
    private static final DefaultBackgroundExecutor DEFAULT = new DefaultBackgroundExecutor();
    private final ThreadPool concurrentExecutor;

    public static BackgroundExecutor get() {
        return DEFAULT;
    }

    public DefaultBackgroundExecutor() {
        this(new LoggingUncaughtExceptionHandler());
    }

    public DefaultBackgroundExecutor(Thread.UncaughtExceptionHandler handler) {
        this("background", handler);
    }

    public DefaultBackgroundExecutor(String prefix) {
        this(prefix, new LoggingUncaughtExceptionHandler());
    }

    public DefaultBackgroundExecutor(String prefix, Thread.UncaughtExceptionHandler handler) {
        this(ThreadPoolFactory.get(prefix, handler));
    }

    public DefaultBackgroundExecutor(ThreadPool concurrentExecutor) {
        this.concurrentExecutor = concurrentExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> execute(Controller controller, BackgroundActionRegistry registry, BackgroundAction<T> action) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run action %s in background", action));
        }
        registry.add(action);
        action.init();
        BackgroundCallable<T> command = new BackgroundCallable<T>(action, controller);
        try {
            Future<T> task = this.concurrentExecutor.execute(command);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Scheduled background runnable %s for execution", action));
            }
            Future<T> future = task;
            return future;
        }
        catch (RejectedExecutionException e) {
            log.error((Object)String.format("Error scheduling background task %s for execution. %s", action, e.getMessage()));
            action.cleanup();
            Future future = ConcurrentUtils.constantFuture(null);
            return future;
        }
        finally {
            registry.remove(action);
        }
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Terminating concurrent executor thread pool %s", this.concurrentExecutor));
        }
        this.concurrentExecutor.shutdown(false);
    }
}

